/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.testlib;

import com.github.jferard.fastods.testlib.ZipUTF8WriterMock;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ZipUTF8WriterMockHandler
implements InvocationHandler {
    private final ZipUTF8WriterMock mock;

    public static ZipUTF8WriterMockHandler create() {
        return new ZipUTF8WriterMockHandler(ZipUTF8WriterMock.createMock());
    }

    ZipUTF8WriterMockHandler(ZipUTF8WriterMock mock) {
        this.mock = mock;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        String name = method.getName();
        if (name.equals("append")) {
            if (objects[0] instanceof Character) {
                this.mock.append(((Character)objects[0]).charValue());
            } else if (objects.length > 1) {
                this.mock.append((CharSequence)objects[0], (Integer)objects[1], (Integer)objects[2]);
            } else {
                this.mock.append((CharSequence)objects[0]);
            }
            return this.mock;
        }
        if (name.equals("close")) {
            this.mock.close();
        } else if (name.equals("closeEntry")) {
            this.mock.closeEntry();
        } else if (name.equals("finish")) {
            this.mock.finish();
        } else if (name.equals("flush")) {
            this.mock.flush();
        } else if (name.equals("putNextEntry")) {
            this.mock.putNextEntry((ZipEntry)objects[0]);
        } else if (name.equals("setComment")) {
            this.mock.setComment((String)objects[0]);
        }
        return null;
    }

    public <T> T getInstance(Class<T> cls) {
        ClassLoader classLoader = cls.getClassLoader();
        Class[] classes = new Class[]{cls};
        return (T)Proxy.newProxyInstance(classLoader, classes, (InvocationHandler)this);
    }

    public String getEntryAsString(String name) {
        StringBuilder stringBuilder = this.mock.getBuilder(name);
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    public Document getEntryAsDocument(String name) throws IOException, SAXException, ParserConfigurationException {
        StringBuilder stringBuilder = this.mock.getBuilder(name);
        if (stringBuilder == null) {
            return null;
        }
        String xml = stringBuilder.toString();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(xml)));
    }
}

