/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsFileDirectWriter;
import com.github.jferard.fastods.util.FileOpenResult;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilder;
import com.github.jferard.fastods.util.ZipUTF8WriterImpl;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class OdsFileWriterBuilder {
    private final Logger logger;
    private final NamedOdsDocument document;
    private OutputStream out;
    private ZipUTF8WriterBuilder builder;
    private String filename;

    OdsFileWriterBuilder(Logger logger, NamedOdsDocument document) {
        this.logger = logger;
        this.document = document;
        this.builder = ZipUTF8WriterImpl.builder();
    }

    @Deprecated
    public OdsFileWriterBuilder filename(String filename) {
        this.filename = filename;
        return this;
    }

    public OdsFileWriterBuilder outputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public OdsFileWriterBuilder openResult(FileOpenResult lockResult) throws FileNotFoundException {
        this.out = lockResult.getStream();
        return this;
    }

    public NamedOdsFileWriter build() throws FileNotFoundException {
        if (this.out == null) {
            this.out = new FileOutputStream(this.filename);
        }
        ZipUTF8Writer writer = this.builder.build(this.out);
        return new OdsFileDirectWriter(this.logger, XMLUtil.create(), this.document, writer);
    }

    public OdsFileWriterBuilder zipBuilder(ZipUTF8WriterBuilder builder) {
        this.builder = builder;
        return this;
    }
}

