/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Shape;
import com.github.jferard.fastods.TableBuilder;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.style.TableColumnStyle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

class TableAppender {
    private static final int MAX_COLUMN_COUNT = 1024;
    private final TableBuilder builder;
    private boolean preambleWritten = false;
    private int nullFieldCounter;

    TableAppender(TableBuilder builder) {
        this.builder = builder;
    }

    public void appendXMLToContentEntry(XMLUtil util, Appendable appendable) throws IOException {
        this.appendPreamble(util, appendable);
        this.appendRows(util, appendable);
        this.appendPostamble(appendable);
    }

    public void appendPostamble(Appendable appendable) throws IOException {
        appendable.append("</table:table>");
    }

    public void appendPreamble(XMLUtil util, Appendable appendable) throws IOException {
        if (this.preambleWritten) {
            return;
        }
        appendable.append("<table:table");
        util.appendEAttribute(appendable, "table:name", this.builder.getName());
        util.appendEAttribute(appendable, "table:style-name", this.builder.getStyleName());
        util.appendAttribute(appendable, (CharSequence)"table:print", false);
        appendable.append(">");
        this.appendForms(util, appendable);
        this.appendColumnStyles(util, appendable, this.builder.getColumnStyles());
        this.appendShapes(util, appendable, this.builder.getShapes());
        this.preambleWritten = true;
    }

    private void appendShapes(XMLUtil util, Appendable appendable, List<Shape> shapes) throws IOException {
        if (shapes.isEmpty()) {
            return;
        }
        appendable.append("<table:shapes>");
        for (Shape shape : shapes) {
            shape.appendXMLContent(util, appendable);
        }
        appendable.append("</table:shapes>");
    }

    private void appendForms(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<office:forms");
        util.appendAttribute(appendable, (CharSequence)"form:automatic-focus", false);
        util.appendAttribute(appendable, (CharSequence)"form:apply-design-mode", false);
        appendable.append("/>");
    }

    public void appendAllAvailableRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appendPreamble(util, appendable);
        this.appendRows(util, appendable, 0);
    }

    public void appendRemainingRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        if (rowIndex == 0) {
            this.appendPreamble(util, appendable);
        }
        this.appendRows(util, appendable, rowIndex);
        this.appendPostamble(appendable);
    }

    public void appendSomeAvailableRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        if (rowIndex == 0) {
            this.appendPreamble(util, appendable);
        }
        this.appendRows(util, appendable, rowIndex);
    }

    private void appendColumnStyles(XMLUtil xmlUtil, Appendable appendable, Iterable<TableColumnStyle> columnStyles) throws IOException {
        Iterator<TableColumnStyle> iterator = columnStyles.iterator();
        if (!iterator.hasNext()) {
            TableColumnStyle.DEFAULT_TABLE_COLUMN_STYLE.appendXMLToTable(xmlUtil, appendable, 1024);
            return;
        }
        int count = 1;
        int endCount = 1024;
        TableColumnStyle curTCS = iterator.next();
        while (iterator.hasNext()) {
            TableColumnStyle prevTCS = curTCS;
            curTCS = iterator.next();
            if (curTCS.equals(prevTCS)) {
                ++count;
                continue;
            }
            prevTCS.appendXMLToTable(xmlUtil, appendable, count);
            endCount -= count;
            count = 1;
        }
        curTCS.appendXMLToTable(xmlUtil, appendable, count);
        TableColumnStyle.DEFAULT_TABLE_COLUMN_STYLE.appendXMLToTable(xmlUtil, appendable, endCount -= count);
    }

    private void appendRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appendRows(util, appendable, 0);
    }

    private void appendRows(XMLUtil util, Appendable appendable, int firstRowIndex) throws IOException {
        if (firstRowIndex == 0) {
            this.nullFieldCounter = 0;
        }
        int size = this.builder.getTableRowsUsedSize();
        for (int r = firstRowIndex; r < size; ++r) {
            TableRowImpl tr = this.builder.getTableRow(r);
            if (tr == null) {
                ++this.nullFieldCounter;
                continue;
            }
            this.appendRepeatedRows(util, appendable);
            tr.appendXMLToTable(util, appendable);
            this.nullFieldCounter = 0;
        }
    }

    private void appendRepeatedRows(XMLUtil util, Appendable appendable) throws IOException {
        if (this.nullFieldCounter <= 0) {
            return;
        }
        appendable.append("<table:table-row");
        if (this.nullFieldCounter > 1) {
            util.appendAttribute(appendable, (CharSequence)"table:number-rows-repeated", this.nullFieldCounter);
        }
        util.appendAttribute(appendable, (CharSequence)"table:style-name", "ro1");
        appendable.append("><table:table-cell/></table:table-row>");
        this.nullFieldCounter = 0;
    }

    public boolean isPreambleWritten() {
        return this.preambleWritten;
    }
}

