/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.datastyle.BooleanStyleBuilder;
import com.github.jferard.fastods.datastyle.CurrencyStyleBuilder;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.datastyle.DateStyleBuilder;
import com.github.jferard.fastods.datastyle.FloatStyleBuilder;
import com.github.jferard.fastods.datastyle.PercentageStyleBuilder;
import com.github.jferard.fastods.datastyle.TimeStyleBuilder;
import java.util.Locale;

public class DataStylesBuilder {
    private final BooleanStyleBuilder booleanStyleBuilder;
    private final CurrencyStyleBuilder currencyStyleBuilder;
    private final DateStyleBuilder dateDataStyleBuilder;
    private final FloatStyleBuilder floatStyleBuilder;
    private final PercentageStyleBuilder percentageStyleBuilder;
    private final TimeStyleBuilder timeStyleBuilder;

    public static DataStylesBuilder create(Locale locale) {
        BooleanStyleBuilder booleanDataStyle = new BooleanStyleBuilder("boolean-data", locale);
        CurrencyStyleBuilder currencyDataStyle = new CurrencyStyleBuilder("currency-data", locale);
        DateStyleBuilder dateDataStyle = new DateStyleBuilder("date-data", locale);
        FloatStyleBuilder numberDataStyle = new FloatStyleBuilder("float-data", locale);
        PercentageStyleBuilder percentageDataStyle = new PercentageStyleBuilder("percentage-data", locale);
        TimeStyleBuilder timeDataStyle = new TimeStyleBuilder("time-data", locale);
        return new DataStylesBuilder(booleanDataStyle, currencyDataStyle, dateDataStyle, numberDataStyle, percentageDataStyle, timeDataStyle);
    }

    public DataStylesBuilder(BooleanStyleBuilder booleanStyleBuilder, CurrencyStyleBuilder currencyStyleBuilder, DateStyleBuilder dateDataStyleBuilder, FloatStyleBuilder floatStyleBuilder, PercentageStyleBuilder percentageStyleBuilder, TimeStyleBuilder timeStyleBuilder) {
        this.booleanStyleBuilder = booleanStyleBuilder;
        this.currencyStyleBuilder = currencyStyleBuilder;
        this.dateDataStyleBuilder = dateDataStyleBuilder;
        this.floatStyleBuilder = floatStyleBuilder;
        this.percentageStyleBuilder = percentageStyleBuilder;
        this.timeStyleBuilder = timeStyleBuilder;
    }

    public BooleanStyleBuilder booleanStyleBuilder() {
        return this.booleanStyleBuilder;
    }

    public CurrencyStyleBuilder currencyStyleBuilder() {
        return this.currencyStyleBuilder;
    }

    public DateStyleBuilder dateStyleBuilder() {
        return this.dateDataStyleBuilder;
    }

    public FloatStyleBuilder floatStyleBuilder() {
        return this.floatStyleBuilder;
    }

    public PercentageStyleBuilder percentageStyleBuilder() {
        return this.percentageStyleBuilder;
    }

    public TimeStyleBuilder timeStyleBuilder() {
        return this.timeStyleBuilder;
    }

    public DataStyles build() {
        return new DataStyles(this.booleanStyleBuilder.build(), this.currencyStyleBuilder.build(), this.dateDataStyleBuilder.build(), this.floatStyleBuilder.build(), this.percentageStyleBuilder.build(), this.timeStyleBuilder.build());
    }
}

