/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.config.ManifestEntry;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;

public class ManifestElement
implements OdsElement {
    private static final List<ManifestEntry> ENTRIES = Arrays.asList(new ManifestEntry("/", "application/vnd.oasis.opendocument.spreadsheet", null), new ManifestEntry("content.xml", "text/xml", null), new ManifestEntry("styles.xml", "text/xml", null), new ManifestEntry("meta.xml", "text/xml", null), new ManifestEntry("settings.xml", "text/xml", null), new ManifestEntry("Configurations2/", "application/vnd.sun.xml.ui.configuration", null), new ManifestEntry("Configurations2/statusbar/", "", null), new ManifestEntry("Configurations2/accelerator/", "", null), new ManifestEntry("Configurations2/accelerator/current.xml", "", null), new ManifestEntry("Configurations2/floater/", "", null), new ManifestEntry("Configurations2/popupmenu/", "", null), new ManifestEntry("Configurations2/progressbar/", "", null), new ManifestEntry("Configurations2/menubar/", "", null), new ManifestEntry("Configurations2/toolbar/", "", null), new ManifestEntry("Configurations2/images/", "", null), new ManifestEntry("Configurations2/images/Bitmaps/", "", null), new ManifestEntry("Thumbnails/", "", null), new ManifestEntry("Thumbnails/thumbnail.png", "", null));
    private final List<ManifestEntry> manifestEntries;

    public static ManifestElement create() {
        return new ManifestElement(ENTRIES);
    }

    ManifestElement(List<ManifestEntry> initialEntries) {
        this.manifestEntries = new ArrayList<ManifestEntry>(initialEntries);
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new ZipEntry("META-INF/manifest.xml"));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><manifest:manifest xmlns:manifest=\"urn:oasis:names:tc:opendocument:xmlns:manifest:1.0\">");
        for (ManifestEntry entry : this.manifestEntries) {
            entry.appendXMLContent(util, writer);
        }
        writer.write("</manifest:manifest>");
        writer.flush();
        writer.closeEntry();
    }

    public void add(ManifestEntry manifestEntry) {
        this.manifestEntries.add(manifestEntry);
    }
}

