/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.MetaElementBuilder;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.UserDefined;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.ZipEntry;

public class MetaElement
implements OdsElement {
    public static final String GENERATOR = "FastOds/0.7.2";
    public static final String OFFICE_VERSION = "1.2";
    static final SimpleDateFormat DF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    static final SimpleDateFormat DF_TIME;
    private final String description;
    private final String language;
    private final String subject;
    private final String title;
    private final String editingCycles;
    private final String editingDuration;
    private final String initialCreator;
    private final List<String> keyWords;
    private final List<UserDefined> userDefineds;
    private final String creator;
    private final String dateTime;

    public static MetaElementBuilder builder() {
        return new MetaElementBuilder();
    }

    public static MetaElement create() {
        return new MetaElementBuilder().build();
    }

    public MetaElement(String creator, String dateTime, String description, String language, String subject, String title, String editingCycles, String editingDuration, String initialCreator, List<String> keyWords, List<UserDefined> userDefineds) {
        this.dateTime = dateTime;
        this.creator = creator;
        this.description = description;
        this.language = language;
        this.subject = subject;
        this.title = title;
        this.editingCycles = editingCycles;
        this.editingDuration = editingDuration;
        this.initialCreator = initialCreator;
        this.keyWords = keyWords;
        this.userDefineds = userDefineds;
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new ZipEntry("meta.xml"));
        writer.append("<?xml");
        util.appendAttribute((Appendable)writer, (CharSequence)"version", "1.0");
        util.appendAttribute((Appendable)writer, (CharSequence)"encoding", "UTF-8");
        writer.append("?><office:document-meta");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:xlink", "http://www.w3.org/1999/xlink");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:dc", "http://purl.org/dc/elements/1.1/");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:ooo", "http://openoffice.org/2004/office");
        util.appendAttribute((Appendable)writer, (CharSequence)"office:version", OFFICE_VERSION);
        writer.append("><office:meta>");
        util.appendTag(writer, "dc:creator", this.creator);
        util.appendTag(writer, "dc:date", this.dateTime);
        if (this.description != null) {
            util.appendTag(writer, "dc:description", this.description);
        }
        if (this.language != null) {
            util.appendTag(writer, "dc:language", this.language);
        }
        if (this.subject != null) {
            util.appendTag(writer, "dc:subject", this.subject);
        }
        if (this.title != null) {
            util.appendTag(writer, "dc:title", this.title);
        }
        util.appendTag(writer, "meta:generator", GENERATOR);
        util.appendTag(writer, "meta:editing-cycles", this.editingCycles);
        util.appendTag(writer, "meta:editing-duration", this.editingDuration);
        if (this.initialCreator != null) {
            util.appendTag(writer, "meta:initial-creator", this.initialCreator);
        }
        for (String keyword : this.keyWords) {
            util.appendTag(writer, "meta:keyword", keyword);
        }
        for (UserDefined userDefined : this.userDefineds) {
            userDefined.appendXMLContent(util, writer);
        }
        writer.append("</office:meta>").append("</office:document-meta>");
        writer.flush();
        writer.closeEntry();
    }

    static {
        DF_DATE.setTimeZone(TimeZone.getTimeZone("UTC"));
        DF_TIME = new SimpleDateFormat("HH:mm:ss");
        DF_TIME.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

