/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement.config;

import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigItemMapEntrySequence
implements ConfigItemMapEntry {
    private final List<ConfigBlock> blocks;
    private final String name;

    public static ConfigItemMapEntrySequence createSequence() {
        return new ConfigItemMapEntrySequence(null, new ArrayList<ConfigBlock>());
    }

    public static ConfigItemMapEntrySequence createSequence(String name) {
        return new ConfigItemMapEntrySequence(name, new ArrayList<ConfigBlock>());
    }

    ConfigItemMapEntrySequence(String name, List<ConfigBlock> blocks) {
        this.name = name;
        this.blocks = blocks;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.blocks.size();
    }

    @Override
    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    @Override
    public boolean add(ConfigBlock block) {
        return this.blocks.add(block);
    }

    @Override
    public ConfigBlock put(ConfigBlock block) {
        throw new UnsupportedOperationException();
    }

    public void remove(int i) {
        this.blocks.remove(i);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<config:config-item-map-entry");
        if (this.name != null) {
            util.appendEAttribute(appendable, "config:name", this.name);
        }
        appendable.append(">");
        for (ConfigBlock block : this.blocks) {
            block.appendXMLContent(util, appendable);
        }
        appendable.append("</config:config-item-map-entry>");
    }

    @Override
    public Iterator<ConfigBlock> iterator() {
        return this.blocks.iterator();
    }

    public String set(int i, String value) {
        ConfigBlock block = this.blocks.get(i);
        if (block instanceof ConfigItem) {
            ConfigItem item = (ConfigItem)block;
            String previousValue = item.getValue();
            item.setValue(value);
            return previousValue;
        }
        return null;
    }

    @Override
    public boolean add(String name, String type, String value) {
        ConfigItem item = new ConfigItem(name, type, value);
        return this.blocks.add(item);
    }
}

