/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.ElementWithEmbeddedStyles;
import com.github.jferard.fastods.Footer;
import com.github.jferard.fastods.Header;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.AddableToOdsElements;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class MasterPageStyle
implements AddableToOdsElements,
ElementWithEmbeddedStyles {
    private final String layoutName;
    private final Footer footer;
    private final Header header;
    private final String name;

    MasterPageStyle(String name, String layoutName, Header header, Footer footer) {
        this.name = name;
        this.layoutName = layoutName;
        this.footer = footer;
        this.header = header;
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        if (this.header != null) {
            this.header.addEmbeddedStyles(stylesContainer);
        }
        if (this.footer != null) {
            this.footer.addEmbeddedStyles(stylesContainer);
        }
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addMasterPageStyle(this);
    }

    public void appendXMLToMasterStyle(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:master-page");
        util.appendEAttribute(appendable, "style:name", this.name);
        util.appendEAttribute(appendable, "style:page-layout-name", this.layoutName);
        appendable.append("><style:header>");
        this.header.appendXMLToMasterStyle(util, appendable);
        appendable.append("</style:header>");
        appendable.append("<style:header-left");
        util.appendAttribute(appendable, (CharSequence)"style:display", false);
        appendable.append("/>");
        appendable.append("<style:footer>");
        this.footer.appendXMLToMasterStyle(util, appendable);
        appendable.append("</style:footer>");
        appendable.append("<style:footer-left");
        util.appendAttribute(appendable, (CharSequence)"style:display", false);
        appendable.append("/>");
        appendable.append("</style:master-page>");
    }

    public boolean hasFooter() {
        return this.footer != null;
    }

    public boolean hasHeader() {
        return this.header != null;
    }

    public String getName() {
        return this.name;
    }
}

