/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.ElementWithEmbeddedStyles;
import com.github.jferard.fastods.attribute.PagePrintOrientation;
import com.github.jferard.fastods.attribute.PageWritingMode;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.AddableToOdsElements;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyleBuilder;
import com.github.jferard.fastods.style.PaperFormat;
import com.github.jferard.fastods.util.Hidable;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class PageStyle
implements AddableToOdsElements,
ElementWithEmbeddedStyles,
Hidable {
    public static final String DEFAULT_MASTER_PAGE_NAME = "DefaultMasterPage";
    public static final PaperFormat DEFAULT_FORMAT = PaperFormat.A4;
    public static final PagePrintOrientation DEFAULT_PRINT_ORIENTATION;
    public static final PageWritingMode DEFAULT_WRITING_MODE;
    public static final PageStyle DEFAULT_MASTER_PAGE_STYLE;
    public static final PageStyle DEFAULT_PAGE_STYLE;
    private final boolean hidden;
    private final MasterPageStyle masterPageStyle;
    private final PageLayoutStyle pageLayoutStyle;

    public static PageStyleBuilder builder(String name) {
        return new PageStyleBuilder(name);
    }

    PageStyle(boolean hidden, MasterPageStyle masterPageStyle, PageLayoutStyle pageLayoutStyle) {
        this.hidden = hidden;
        this.masterPageStyle = masterPageStyle;
        this.pageLayoutStyle = pageLayoutStyle;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public MasterPageStyle getMasterPageStyle() {
        return this.masterPageStyle;
    }

    public PageLayoutStyle getPageLayoutStyle() {
        return this.pageLayoutStyle;
    }

    public String getMasterName() {
        return this.masterPageStyle.getName();
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        this.masterPageStyle.addEmbeddedStyles(stylesContainer);
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addMasterPageStyle(this.masterPageStyle);
        odsElements.addPageLayoutStyle(this.pageLayoutStyle);
    }

    public void appendXMLToAutomaticStyle(XMLUtil util, Appendable appendable) throws IOException {
        this.pageLayoutStyle.appendXMLToAutomaticStyle(util, appendable);
    }

    public void appendXMLToMasterStyle(XMLUtil util, Appendable appendable) throws IOException {
        this.masterPageStyle.appendXMLToMasterStyle(util, appendable);
    }

    static {
        DEFAULT_WRITING_MODE = PageWritingMode.LRTB;
        DEFAULT_PRINT_ORIENTATION = PagePrintOrientation.VERTICAL;
        DEFAULT_PAGE_STYLE = PageStyle.builder("Mpm1").build();
        DEFAULT_MASTER_PAGE_STYLE = PageStyle.builder(DEFAULT_MASTER_PAGE_NAME).build();
    }
}

