/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.DrawFrame;
import com.github.jferard.fastods.DrawImage;
import com.github.jferard.fastods.DrawObject;
import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ref.RangeRef;
import com.github.jferard.fastods.style.DrawFillBitmap;
import com.github.jferard.fastods.style.GraphicStyle;
import com.github.jferard.fastods.tool.OdsArchiveExplorer;
import com.github.jferard.fastods.util.FileUtil;
import com.github.jferard.fastods.util.SVGRectangle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public class InsertHelper {
    private final FileUtil fileUtil;

    public static InsertHelper create() {
        return new InsertHelper(FileUtil.create());
    }

    public InsertHelper(FileUtil fileUtil) {
        this.fileUtil = fileUtil;
    }

    public void insertImage(OdsDocument document, Table table, String frameName, File source, String destName, SVGRectangle rectangle) throws IOException {
        String sourceName = source.getName();
        String mediaType = this.getMediaType(sourceName);
        document.addExtraFile("Pictures/" + destName, mediaType, this.fileUtil.readFile(source));
        table.addShape(DrawFrame.builder(frameName, new DrawImage("Pictures/" + destName), rectangle).build());
    }

    public void insertImage(OdsDocument document, Table table, String frameName, InputStream sourceStream, String destName, SVGRectangle rectangle) throws IOException {
        String mediaType = this.getMediaType(destName);
        document.addExtraFile("Pictures/" + destName, mediaType, this.fileUtil.readStream(sourceStream));
        table.addShape(DrawFrame.builder(frameName, new DrawImage("Pictures/" + destName), rectangle).build());
    }

    private String getMediaType(String sourceName) {
        String extension = sourceName.substring(sourceName.lastIndexOf(".") + 1).toLowerCase(Locale.US);
        if (extension.equals("jpg") || extension.equals("jpeg")) {
            return "image/jpeg";
        }
        return "image/" + extension;
    }

    public DrawFillBitmap createDrawFillImage(OdsDocument document, InputStream sourceStream, String name, String href) throws IOException {
        byte[] bytes = FileUtil.create().readStream(sourceStream);
        document.addExtraFile(href, this.getMediaType(href), bytes);
        DrawFillBitmap drawFillImage = new DrawFillBitmap(name, href);
        return drawFillImage;
    }

    public void insertObject(OdsDocument document, Table table, String frameName, String objectName, String objectMediaType, String objectVersion, InputStream sourceStream, SVGRectangle rectangle, GraphicStyle gs) throws IOException {
        document.addExtraObject(objectName, objectMediaType, objectVersion);
        Map<String, OdsArchiveExplorer.OdsFile> fileByName = new OdsArchiveExplorer(this.fileUtil, sourceStream).explore();
        for (Map.Entry<String, OdsArchiveExplorer.OdsFile> entry : fileByName.entrySet()) {
            String name = entry.getKey();
            if (name.equals("META-INF/manifest.xml") || name.equals("mimetype") || name.startsWith("Thumbnails")) continue;
            entry.getValue().addToDocument(document, objectName + "/");
        }
        table.addShape(DrawFrame.builder(frameName, new DrawObject("./" + objectName, Collections.<RangeRef>emptyList()), rectangle).style(gs).build());
    }
}

