/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class OdsArchiveExplorer {
    private final FileUtil fileUtil;
    private final InputStream sourceStream;
    private final Map<String, OdsFile> fileByName;

    public OdsArchiveExplorer(FileUtil fileUtil, InputStream sourceStream) {
        this.fileUtil = fileUtil;
        this.sourceStream = sourceStream;
        this.fileByName = new HashMap<String, OdsFile>();
    }

    public Map<String, OdsFile> explore() throws IOException {
        ZipInputStream zipStream = new ZipInputStream(this.sourceStream);
        ZipEntry zipEntry = zipStream.getNextEntry();
        while (zipEntry != null) {
            String name = zipEntry.getName();
            byte[] bytes = this.fileUtil.readStream(zipStream);
            if (name.equals("META-INF/manifest.xml")) {
                this.extractMediaTypeByName(bytes);
            }
            this.putBytes(name, bytes);
            zipEntry = zipStream.getNextEntry();
        }
        return this.fileByName;
    }

    private void putBytes(String name, byte[] bytes) {
        OdsFile odsFile = this.getOrCreateOdsFile(name);
        odsFile.setBytes(bytes);
    }

    private void putMediaType(String name, String mediaType) {
        OdsFile odsFile = this.getOrCreateOdsFile(name);
        odsFile.setMediaType(mediaType);
    }

    private OdsFile getOrCreateOdsFile(String name) {
        OdsFile odsFile = this.fileByName.get(name);
        if (odsFile == null) {
            odsFile = new OdsFile(name);
            this.fileByName.put(name, odsFile);
        }
        return odsFile;
    }

    private void extractMediaTypeByName(byte[] bytes) throws IOException {
        try {
            Document manifest = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(bytes));
            this.extractMediaTypeByName(manifest);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    private void extractMediaTypeByName(Document manifest) {
        NodeList mEntries = manifest.getElementsByTagName("manifest:file-entry");
        for (int i = 0; i < mEntries.getLength(); ++i) {
            Node mEntry = mEntries.item(i);
            NamedNodeMap attributes = mEntry.getAttributes();
            this.putMediaType(attributes.getNamedItem("manifest:full-path").getNodeValue(), attributes.getNamedItem("manifest:media-type").getNodeValue());
        }
    }

    static class OdsFile {
        private final String name;
        private byte[] bytes;
        private String mediaType;

        OdsFile(String name) {
            this.name = name;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        public void addToDocument(OdsDocument document, String prefix) {
            if (this.bytes == null) {
                document.addExtraObject(prefix + this.name, this.mediaType, null);
            } else {
                document.addExtraFile(prefix + this.name, this.mediaType, this.bytes);
            }
        }
    }
}

