/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final int START_SIZE = 0x100000;
    private final int bufferSize;
    private final int startSize;

    public static FileUtil create() {
        return new FileUtil(65536, 0x100000);
    }

    public FileUtil(int bufferSize, int startSize) {
        this.bufferSize = bufferSize;
        this.startSize = startSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            byte[] byArray = this.readStream(is, (int)file.length());
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public byte[] readStream(InputStream is) throws IOException {
        return this.readStream(is, this.startSize);
    }

    public byte[] readStream(InputStream is, int customStartSize) throws IOException {
        byte[] bytes = new byte[customStartSize];
        int total_count = 0;
        while (true) {
            if (total_count + this.bufferSize >= bytes.length) {
                byte[] new_bytes = new byte[2 * bytes.length];
                System.arraycopy(bytes, 0, new_bytes, 0, total_count);
                bytes = new_bytes;
                continue;
            }
            int count = is.read(bytes, total_count, this.bufferSize);
            if (count == -1) break;
            total_count += count;
        }
        byte[] new_bytes = new byte[total_count];
        System.arraycopy(bytes, 0, new_bytes, 0, total_count);
        return new_bytes;
    }
}

