/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.util.MacroLibraryBuilder;
import com.github.jferard.fastods.util.MacroModule;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.List;

public class MacroLibrary {
    private final String name;
    private final boolean readOnly;
    private final List<MacroModule> modules;

    public static MacroLibraryBuilder builder() {
        return new MacroLibraryBuilder();
    }

    public MacroLibrary(String name, boolean readOnly, List<MacroModule> modules) {
        this.name = name;
        this.readOnly = readOnly;
        this.modules = modules;
    }

    public void add(XMLUtil util, OdsDocument document) throws IOException {
        String nameSlash = "Basic/" + this.name + "/";
        document.addExtraDir(nameSlash);
        document.addExtraFile(nameSlash + "script-lb.xml", "text/xml", this.index(util));
        for (MacroModule module : this.modules) {
            module.add(util, document, nameSlash);
        }
    }

    private byte[] index(XMLUtil util) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE library:library PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"library.dtd\">");
        sb.append("<library:library xmlns:library=\"http://openoffice.org/2000/library\"");
        util.appendAttribute((Appendable)sb, (CharSequence)"library:name", this.name);
        util.appendAttribute((Appendable)sb, (CharSequence)"library:readonly", this.readOnly);
        util.appendAttribute((Appendable)sb, (CharSequence)"library:passwordprotected", false);
        sb.append(">");
        for (MacroModule module : this.modules) {
            module.appendIndexLine(util, sb);
        }
        sb.append("</library:library>");
        return sb.toString().getBytes(ZipUTF8Writer.UTF_8);
    }

    public void appendIndexLine(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<library:library");
        util.appendAttribute(appendable, (CharSequence)"library:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"library:link", false);
        appendable.append("/>");
    }
}

