/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.util.MacroLibrary;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class MacroLibraryContainer {
    private static final String CONTAINER_NAME = "Basic";
    public static final String CONTAINER_NAME_SLASH = "Basic/";
    private final XMLUtil util;
    private final List<MacroLibrary> libraries;

    public static MacroLibraryContainer create(MacroLibrary ... libraries) {
        XMLUtil xmlUtil = XMLUtil.create();
        return new MacroLibraryContainer(xmlUtil, Arrays.asList(libraries));
    }

    public MacroLibraryContainer(XMLUtil util, List<MacroLibrary> libraries) {
        this.util = util;
        this.libraries = libraries;
    }

    public void add(OdsDocument document) throws IOException {
        document.addExtraDir(CONTAINER_NAME_SLASH);
        document.addExtraFile("Basic/script-lc.xml", "text/xml", this.container(this.util));
        for (MacroLibrary library : this.libraries) {
            library.add(this.util, document);
        }
    }

    private byte[] container(XMLUtil util) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE library:libraries PUBLIC \"-//OpenOffice.org//DTD OfficeDocument 1.0//EN\" \"libraries.dtd\">\n<library:libraries xmlns:library=\"http://openoffice.org/2000/library\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        for (MacroLibrary library : this.libraries) {
            library.appendIndexLine(util, sb);
        }
        sb.append("</library:libraries>");
        return sb.toString().getBytes(ZipUTF8Writer.UTF_8);
    }
}

