/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.ZipUTF8Writer;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUTF8WriterImpl
implements ZipUTF8Writer {
    private final Writer writer;
    private final ZipOutputStream zipStream;

    ZipUTF8WriterImpl(ZipOutputStream zipStream, Writer writer) {
        this.zipStream = zipStream;
        this.writer = writer;
    }

    public static ZipUTF8WriterBuilder builder() {
        return new ZipUTF8WriterBuilder();
    }

    @Override
    public Appendable append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public Appendable append(CharSequence arg0) throws IOException {
        return this.writer.append(arg0);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        return this.writer.append(csq, start, end);
    }

    @Override
    public void close() throws IOException {
        this.zipStream.close();
    }

    @Override
    public void closeEntry() throws IOException {
        this.writer.flush();
        this.zipStream.closeEntry();
    }

    @Override
    public void finish() throws IOException {
        this.writer.flush();
        this.zipStream.finish();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void putNextEntry(ZipEntry entry) throws IOException {
        this.zipStream.putNextEntry(entry);
    }

    @Override
    public void setComment(String comment) {
        this.zipStream.setComment(comment);
    }

    @Override
    public void write(CharSequence sequence) throws IOException {
        this.writer.append(sequence);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.zipStream.write(bytes);
    }
}

