/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.AnonymousOdsDocument;
import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilder;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilderImpl;
import com.github.jferard.fastods.util.ZipUTF8WriterImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnonymousOdsFileWriter {
    private final AnonymousOdsDocument document;
    private final Logger logger;

    AnonymousOdsFileWriter(Logger logger, AnonymousOdsDocument document) {
        this.logger = logger;
        this.document = document;
    }

    public OdsDocument document() {
        return this.document;
    }

    public void save(OutputStream out) throws IOException {
        ZipUTF8Writer writer = ZipUTF8WriterImpl.builder().build(out);
        this.save(writer);
        writer.finish();
        writer.flush();
    }

    @Deprecated
    public void save(OutputStream out, ZipUTF8WriterBuilderImpl builder) throws IOException {
        ZipUTF8Writer writer = builder.build(out);
        this.save(writer);
        writer.finish();
    }

    public void save(ZipUTF8Writer writer) throws IOException {
        this.document.save(writer);
    }

    public void saveAs(String filename) throws IOException {
        this.saveAs(new File(filename));
    }

    public void saveAs(File file) throws IOException {
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                this.save(out);
            }
            finally {
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, "Can't open " + file, e);
            throw new IOException(e);
        }
        catch (NullPointerException e) {
            this.logger.log(Level.SEVERE, "No file", e);
            throw new IOException(e);
        }
    }

    public void saveAs(String filename, ZipUTF8WriterBuilder builder) throws IOException {
        this.saveAs(new File(filename), builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(File file, ZipUTF8WriterBuilder builder) throws IOException {
        try {
            FileOutputStream out = new FileOutputStream(file);
            ZipUTF8Writer writer = builder.build(out);
            try {
                this.save(writer);
            }
            finally {
                writer.finish();
                writer.close();
            }
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, "Can't open " + file, e);
            throw new IOException(e);
        }
    }
}

