/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CommonOdsDocument;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.attribute.CellType;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.ScriptEventListener;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.FontFaceContainerStyle;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.AutoFilter;
import com.github.jferard.fastods.util.Container;
import com.github.jferard.fastods.util.PilotTable;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NamedOdsDocument
implements OdsDocument,
StylesContainer {
    private final Logger logger;
    private final OdsElements odsElements;
    private final XMLUtil xmlUtil;
    private final CommonOdsDocument commonOdsDocument;

    static NamedOdsDocument create(Logger logger, XMLUtil xmlUtil, OdsElements odsElements) {
        return new NamedOdsDocument(logger, xmlUtil, odsElements, new CommonOdsDocument(odsElements));
    }

    NamedOdsDocument(Logger logger, XMLUtil xmlUtil, OdsElements odsElements, CommonOdsDocument commonOdsDocument) {
        this.logger = logger;
        this.odsElements = odsElements;
        this.xmlUtil = xmlUtil;
        this.commonOdsDocument = commonOdsDocument;
    }

    @Override
    public Table addTable(String name) throws IOException {
        return this.commonOdsDocument.addTable(name);
    }

    @Override
    public Table addTable(String name, int rowCapacity, int columnCapacity) throws IOException {
        return this.commonOdsDocument.addTable(name, rowCapacity, columnCapacity);
    }

    @Override
    public boolean addTable(Table table) throws IOException {
        return this.commonOdsDocument.addTable(table);
    }

    @Override
    public Table createTable(String name) throws IOException {
        return this.commonOdsDocument.createTable(name);
    }

    @Override
    public Table createTable(String name, int rowCapacity, int columnCapacity) throws IOException {
        return this.commonOdsDocument.createTable(name, rowCapacity, columnCapacity);
    }

    @Override
    public Table getTable(int n) throws FastOdsException {
        return this.commonOdsDocument.getTable(n);
    }

    @Override
    public Table getTable(String name) throws FastOdsException {
        return this.commonOdsDocument.getTable(name);
    }

    @Override
    public Table getOrAddTable(String name) throws IOException {
        return this.commonOdsDocument.getOrAddTable(name);
    }

    @Override
    public String getTableName(int n) throws FastOdsException {
        return this.commonOdsDocument.getTableName(n);
    }

    @Override
    public int getTableNumber(String name) {
        return this.commonOdsDocument.getTableNumber(name);
    }

    @Override
    public List<Table> getTables() {
        return this.commonOdsDocument.getTables();
    }

    @Override
    public boolean setActiveTable(int tableIndex) {
        return this.commonOdsDocument.setActiveTable(tableIndex);
    }

    @Override
    public void setViewSetting(String viewId, String item, String value) {
        this.commonOdsDocument.setViewSetting(viewId, item, value);
    }

    @Override
    public int tableCount() {
        return this.commonOdsDocument.tableCount();
    }

    @Override
    @Deprecated
    public void addAutoFilter(String rangeName, Table table, int r1, int c1, int r2, int c2) {
        AutoFilter autoFilter = AutoFilter.builder(rangeName, table, r1, c1, r2, c2).build();
        this.commonOdsDocument.addAutoFilter(autoFilter);
    }

    @Override
    public void freezeCells(Table table, int rowCount, int colCount) {
        this.commonOdsDocument.freezeCells(table, rowCount, colCount);
    }

    void addObserver(NamedOdsFileWriter writer) {
        this.odsElements.addObserver(writer);
    }

    public void addCellStyle(TableCellStyle style, CellType ... types) {
        this.odsElements.addCellStyle(style, types);
    }

    @Override
    public boolean addDataStyle(DataStyle dataStyle) {
        return this.odsElements.addDataStyle(dataStyle);
    }

    @Override
    public boolean addMasterPageStyle(MasterPageStyle masterPageStyle) {
        return this.odsElements.addMasterPageStyle(masterPageStyle);
    }

    @Override
    public boolean addNewDataStyleFromCellStyle(TableCellStyle style) {
        return this.odsElements.addNewDataStyleFromCellStyle(style);
    }

    @Override
    public boolean addPageLayoutStyle(PageLayoutStyle pageLayoutStyle) {
        return this.odsElements.addPageLayoutStyle(pageLayoutStyle);
    }

    @Override
    public boolean addPageStyle(PageStyle ps) {
        return this.odsElements.addPageStyle(ps);
    }

    @Override
    public boolean addContentStyle(ObjectStyle objectStyle) {
        return this.odsElements.addContentStyle(objectStyle);
    }

    @Override
    public boolean addStylesStyle(ObjectStyle objectStyle) {
        return this.odsElements.addStylesStyle(objectStyle);
    }

    @Override
    public TableCellStyle addChildCellStyle(TableCellStyle style, DataStyle dataStyle) {
        return this.odsElements.addChildCellStyle(style, dataStyle);
    }

    @Override
    public boolean addContentFontFaceContainerStyle(FontFaceContainerStyle objectStyle) {
        return this.odsElements.addContentFontFaceContainerStyle(objectStyle);
    }

    @Override
    public boolean addStylesFontFaceContainerStyle(FontFaceContainerStyle ffcStyle) {
        return this.odsElements.addStylesFontFaceContainerStyle(ffcStyle);
    }

    @Override
    public void setDataStylesMode(Container.Mode mode) {
        this.commonOdsDocument.setDataStylesMode(mode);
    }

    @Override
    public void setMasterPageStyleMode(Container.Mode mode) {
        this.commonOdsDocument.setMasterPageStyleMode(mode);
    }

    @Override
    public void setPageLayoutStyleMode(Container.Mode mode) {
        this.commonOdsDocument.setPageLayoutStyleMode(mode);
    }

    @Override
    public void setPageStyleMode(Container.Mode mode) {
        this.commonOdsDocument.setPageStyleMode(mode);
    }

    @Override
    public void setObjectStyleMode(Container.Mode mode) {
        this.commonOdsDocument.setObjectStyleMode(mode);
    }

    public void debugStyles() {
        this.odsElements.debugStyles();
    }

    public void freezeStyles() {
        this.odsElements.freezeStyles();
    }

    public void prepare() throws IOException {
        this.odsElements.prepareAsync();
    }

    @Override
    public void addExtraFile(String fullPath, String mediaType, byte[] bytes) {
        this.commonOdsDocument.addExtraFile(fullPath, mediaType, bytes);
    }

    @Override
    public void addExtraDir(String fullPath) {
        this.commonOdsDocument.addExtraDir(fullPath);
    }

    @Override
    public void addExtraObject(String fullPath, String mediaType, String version) {
        this.commonOdsDocument.addExtraObject(fullPath, mediaType, version);
    }

    @Override
    public void addEvents(ScriptEventListener ... events) {
        this.commonOdsDocument.addEvents(events);
    }

    @Override
    public void addPilotTable(PilotTable pilot) {
        this.commonOdsDocument.addPilotTable(pilot);
    }

    @Override
    public void addAutoFilter(AutoFilter autoFilter) {
        this.commonOdsDocument.addAutoFilter(autoFilter);
    }

    public void save() throws IOException {
        this.odsElements.saveAsync();
        this.logger.log(Level.FINE, "file saved");
    }
}

