/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsAsyncFlusher;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

public class OdsFileWriterAdapter
implements NamedOdsFileWriter {
    private final Logger logger;
    private final NamedOdsFileWriter adaptee;
    private final Queue<OdsAsyncFlusher> flushers;
    private boolean stopped;

    public static OdsFileWriterAdapter create(Logger logger, NamedOdsFileWriter adaptee) {
        return new OdsFileWriterAdapter(logger, adaptee, new LinkedList<OdsAsyncFlusher>());
    }

    OdsFileWriterAdapter(Logger logger, NamedOdsFileWriter adaptee, Queue<OdsAsyncFlusher> flushers) {
        this.logger = logger;
        this.adaptee = adaptee;
        this.flushers = flushers;
    }

    @Override
    public void close() {
    }

    @Override
    public NamedOdsDocument document() {
        return this.adaptee.document();
    }

    @Override
    public synchronized void save() {
    }

    @Override
    public synchronized void update(OdsAsyncFlusher flusher) {
        this.flushers.add(flusher);
        this.logger.fine("Add new flusher: " + flusher);
        this.notifyAll();
    }

    public synchronized void flushAdaptee() throws IOException {
        OdsAsyncFlusher flusher = this.flushers.poll();
        this.logger.fine("Retrieve first flusher: " + flusher);
        if (flusher == null) {
            this.notifyAll();
            return;
        }
        while (flusher != null) {
            this.adaptee.update(flusher);
            if (flusher.isEnd()) {
                this.stopped = true;
                this.notifyAll();
                return;
            }
            flusher = this.flushers.poll();
            this.logger.fine("Retrieve next flusher: " + flusher);
        }
        this.notifyAll();
    }

    public synchronized boolean isNotStopped() {
        return !this.stopped;
    }

    public synchronized void waitForData() {
        while (this.flushers.isEmpty() && this.isNotStopped()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

