/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Shape;
import com.github.jferard.fastods.TableBuilder;
import com.github.jferard.fastods.TableColumnImpl;
import com.github.jferard.fastods.TableRowImpl;
import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.util.FastFullList;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TableAppender {
    private static final int MAX_COLUMN_COUNT = 1024;
    private final TableBuilder builder;
    private boolean preambleWritten = false;
    private int nullFieldCounter;

    TableAppender(TableBuilder builder) {
        this.builder = builder;
    }

    public void appendXMLToContentEntry(XMLUtil util, Appendable appendable) throws IOException {
        this.appendPreamble(util, appendable);
        this.appendRows(util, appendable);
        this.appendPostamble(appendable);
    }

    public void appendPostamble(Appendable appendable) throws IOException {
        appendable.append("</table:table>");
    }

    public void appendPreambleOnce(XMLUtil util, Appendable appendable) throws IOException {
        if (!this.preambleWritten) {
            this.appendPreamble(util, appendable);
            this.preambleWritten = true;
        }
    }

    public void appendPreamble(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:table");
        util.appendEAttribute(appendable, "table:name", this.builder.getName());
        util.appendEAttribute(appendable, "table:style-name", this.builder.getStyleName());
        util.appendAttribute(appendable, (CharSequence)"table:print", false);
        Map<String, CharSequence> customValueByAttribute = this.builder.getCustomValueByAttribute();
        if (customValueByAttribute != null) {
            for (Map.Entry<String, CharSequence> entry : customValueByAttribute.entrySet()) {
                util.appendAttribute(appendable, (CharSequence)entry.getKey(), entry.getValue());
            }
        }
        appendable.append(">");
        this.appendForms(util, appendable, this.builder.getForms());
        this.appendColumns(util, appendable, this.builder.getColumns());
        this.appendShapes(util, appendable, this.builder.getShapes());
    }

    private void appendShapes(XMLUtil util, Appendable appendable, List<Shape> shapes) throws IOException {
        if (shapes.isEmpty()) {
            return;
        }
        appendable.append("<table:shapes>");
        for (Shape shape : shapes) {
            shape.appendXMLContent(util, appendable);
        }
        appendable.append("</table:shapes>");
    }

    private void appendForms(XMLUtil util, Appendable appendable, List<XMLConvertible> forms) throws IOException {
        if (forms.isEmpty()) {
            return;
        }
        appendable.append("<office:forms");
        util.appendAttribute(appendable, (CharSequence)"form:automatic-focus", false);
        util.appendAttribute(appendable, (CharSequence)"form:apply-design-mode", false);
        appendable.append(">");
        for (XMLConvertible form : forms) {
            form.appendXMLContent(util, appendable);
        }
        appendable.append("</office:forms>");
    }

    public void appendAllAvailableRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appendPreambleOnce(util, appendable);
        this.appendRows(util, appendable, 0);
    }

    public void appendRemainingRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        if (rowIndex == 0) {
            this.appendPreamble(util, appendable);
        }
        this.appendRows(util, appendable, rowIndex);
        this.appendPostamble(appendable);
    }

    public void appendSomeAvailableRowsFrom(XMLUtil util, Appendable appendable, int rowIndex) throws IOException {
        if (rowIndex == 0) {
            this.appendPreamble(util, appendable);
        }
        this.appendRows(util, appendable, rowIndex);
    }

    private void appendColumns(XMLUtil xmlUtil, Appendable appendable, FastFullList<TableColumnImpl> tableColumns) throws IOException {
        Iterator<TableColumnImpl> iterator = tableColumns.iterator();
        if (!iterator.hasNext()) {
            TableColumnImpl.DEFAULT_TABLE_COLUMN.appendXMLToTable(xmlUtil, appendable, 1024);
            return;
        }
        int count = 1;
        int endCount = 1024;
        TableColumnImpl curColumn = iterator.next();
        while (iterator.hasNext()) {
            TableColumnImpl prevColumn = curColumn;
            curColumn = iterator.next();
            if (curColumn.equals(prevColumn)) {
                ++count;
                continue;
            }
            prevColumn.appendXMLToTable(xmlUtil, appendable, count);
            endCount -= count;
            count = 1;
        }
        curColumn.appendXMLToTable(xmlUtil, appendable, count);
        TableColumnImpl.DEFAULT_TABLE_COLUMN.appendXMLToTable(xmlUtil, appendable, endCount -= count);
    }

    private void appendRows(XMLUtil util, Appendable appendable) throws IOException {
        this.appendRows(util, appendable, 0);
    }

    private void appendRows(XMLUtil util, Appendable appendable, int firstRowIndex) throws IOException {
        if (firstRowIndex == 0) {
            this.nullFieldCounter = 0;
        }
        int size = this.builder.getTableRowsUsedSize();
        for (int r = firstRowIndex; r < size; ++r) {
            TableRowImpl tr = this.builder.getTableRow(r);
            if (tr == null) {
                ++this.nullFieldCounter;
                continue;
            }
            this.appendRepeatedRows(util, appendable);
            tr.appendXMLToTable(util, appendable);
            this.nullFieldCounter = 0;
        }
    }

    private void appendRepeatedRows(XMLUtil util, Appendable appendable) throws IOException {
        if (this.nullFieldCounter <= 0) {
            return;
        }
        appendable.append("<table:table-row");
        if (this.nullFieldCounter > 1) {
            util.appendAttribute(appendable, (CharSequence)"table:number-rows-repeated", this.nullFieldCounter);
        }
        util.appendAttribute(appendable, (CharSequence)"table:style-name", "ro1");
        appendable.append("><table:table-cell/></table:table-row>");
        this.nullFieldCounter = 0;
    }

    public boolean isPreambleWritten() {
        return this.preambleWritten;
    }
}

