/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.RowCellWalker;
import com.github.jferard.fastods.RowCellWalkerImpl;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.TableCellImpl;
import com.github.jferard.fastods.TableRow;
import com.github.jferard.fastods.WritableTableCell;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.style.TableRowStyle;
import com.github.jferard.fastods.util.FastFullList;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TableRowImpl
implements TableRow {
    private final Table parentTable;
    private final int rowIndex;
    private final StylesContainer stylesContainer;
    private final WriteUtil writeUtil;
    private final XMLUtil xmlUtil;
    private final FastFullList<WritableTableCell> cells;
    private final boolean libreOfficeMode;
    private DataStyles dataStyles;
    private TableRowStyle rowStyle;
    private TableCellStyle defaultCellStyle;
    private Map<String, CharSequence> customValueByAttribute;

    public static void appendXMLToTable(TableRowImpl row, XMLUtil xmlUtil, Appendable appendable) throws IOException {
        if (row == null) {
            appendable.append("<row />");
        } else {
            row.appendXMLToTable(xmlUtil, appendable);
        }
    }

    TableRowImpl(WriteUtil writeUtil, XMLUtil xmlUtil, StylesContainer stylesContainer, DataStyles dataStyles, boolean libreOfficeMode, Table parentTable, int rowIndex, int columnCapacity) {
        this.writeUtil = writeUtil;
        this.stylesContainer = stylesContainer;
        this.xmlUtil = xmlUtil;
        this.dataStyles = dataStyles;
        this.libreOfficeMode = libreOfficeMode;
        this.parentTable = parentTable;
        this.rowIndex = rowIndex;
        this.rowStyle = TableRowStyle.DEFAULT_TABLE_ROW_STYLE;
        this.cells = FastFullList.newListWithCapacity(columnCapacity);
    }

    public void appendXMLToTable(XMLUtil util, Appendable appendable) throws IOException {
        this.appendRowOpenTag(util, appendable);
        int nullFieldCounter = 0;
        int size = this.cells.usedSize();
        for (int c = 0; c < size; ++c) {
            WritableTableCell cell = this.cells.get(c);
            if (this.hasNoValue(cell)) {
                ++nullFieldCounter;
                continue;
            }
            this.insertBlankCells(util, appendable, nullFieldCounter);
            nullFieldCounter = 0;
            cell.appendXMLToTableRow(util, appendable);
        }
        appendable.append("</table:table-row>");
    }

    private void appendRowOpenTag(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:table-row");
        if (this.rowStyle != null) {
            util.appendEAttribute(appendable, "table:style-name", this.rowStyle.getName());
        }
        if (this.defaultCellStyle != null) {
            util.appendEAttribute(appendable, "table:default-cell-style-name", this.defaultCellStyle.getName());
        }
        if (this.customValueByAttribute != null) {
            for (Map.Entry<String, CharSequence> entry : this.customValueByAttribute.entrySet()) {
                util.appendAttribute(appendable, (CharSequence)entry.getKey(), entry.getValue());
            }
        }
        appendable.append(">");
    }

    private void insertBlankCells(XMLUtil util, Appendable appendable, int nullFieldCounter) throws IOException {
        if (nullFieldCounter <= 0) {
            return;
        }
        appendable.append("<table:table-cell");
        if (nullFieldCounter >= 2) {
            util.appendAttribute(appendable, (CharSequence)"table:number-columns-repeated", nullFieldCounter);
        }
        appendable.append("/>");
    }

    private boolean hasNoValue(TableCell cell) {
        return cell == null || !cell.hasValue();
    }

    @Deprecated
    public RowCellWalker getWalker() {
        return new RowCellWalkerImpl(this);
    }

    public void setCellMerge(int colIndex, int rowMerge, int columnMerge) throws IOException {
        if (rowMerge < 0 || columnMerge < 0) {
            throw new IllegalArgumentException("row merge and col merge must be >= 0");
        }
        if (rowMerge <= 1 && columnMerge <= 1) {
            return;
        }
        this.parentTable.setCellMerge(this.rowIndex, colIndex, rowMerge, columnMerge);
    }

    public void coverRightCells(int colIndex, int n) {
        for (int c = colIndex + 1; c < colIndex + n; ++c) {
            this.getOrCreateCell(c).setCovered();
        }
    }

    public void setColumnsSpanned(int colIndex, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Can't span negative number of columns");
        }
        if (n <= 1) {
            return;
        }
        TableCell firstCell = this.getOrCreateCell(colIndex);
        if (firstCell.isCovered()) {
            throw new IllegalArgumentException("Can't span from covered cell");
        }
        firstCell.markColumnsSpanned(n);
        this.coverRightCells(colIndex, n);
    }

    @Override
    public void setRowFormat(DataStyles format) {
        this.dataStyles = format;
    }

    public void setRowsSpanned(int colIndex, int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Can't span negative number of rows");
        }
        if (n <= 1) {
            return;
        }
        TableCell firstCell = this.getOrCreateCell(colIndex);
        if (firstCell.isCovered()) {
            throw new IllegalArgumentException("Can't span from covered cell");
        }
        this.parentTable.setRowsSpanned(this.rowIndex, colIndex, n);
    }

    public TableCell getOrCreateCell(int colIndex) {
        WritableTableCell cell = this.cells.get(colIndex);
        if (cell == null) {
            cell = new TableCellImpl(this.writeUtil, this.xmlUtil, this.stylesContainer, this.dataStyles, this.libreOfficeMode, this, colIndex);
            this.cells.set(colIndex, cell);
        }
        return cell;
    }

    public void set(int colIndex, WritableTableCell cell) {
        this.cells.set(colIndex, cell);
    }

    @Override
    public void setRowStyle(TableRowStyle rowStyle) {
        this.stylesContainer.addContentStyle(rowStyle);
        this.rowStyle = rowStyle;
    }

    @Override
    public int getColumnCount() {
        return this.cells.usedSize();
    }

    public boolean isCovered(int colIndex) {
        TableCell cell = this.cells.get(colIndex);
        return cell != null && cell.isCovered();
    }

    public TableCellStyle findDefaultCellStyle(int columnIndex) {
        TableCellStyle s = this.defaultCellStyle;
        if (s == null) {
            s = this.parentTable.findDefaultCellStyle(columnIndex);
        }
        return s;
    }

    @Override
    public void setRowDefaultCellStyle(TableCellStyle ts) {
        this.stylesContainer.addContentFontFaceContainerStyle(ts);
        this.stylesContainer.addContentStyle(ts);
        this.defaultCellStyle = ts;
    }

    @Override
    public int rowIndex() {
        return this.rowIndex;
    }

    @Override
    public void removeRowStyle() {
        this.rowStyle = null;
    }

    @Override
    public void setRowAttribute(String attribute, CharSequence value) {
        if (this.customValueByAttribute == null) {
            this.customValueByAttribute = new HashMap<String, CharSequence>();
        }
        this.customValueByAttribute.put(attribute, value);
    }
}

