/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.odselement.EncryptParametersBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class EncryptParameters
implements XMLConvertible {
    private final int uncompressedSize;
    private final int compressedSize;
    private final long crc32;
    private final String compressedCheckSumType;
    private final String compressedCheckSum;
    private final String startKeyGenerationName;
    private final int startKeySize;
    private final String keyDerivationName;
    private final int derivedKeySize;
    private final int derivationIterationCount;
    private final String derivationSalt;
    private final String algorithmName;
    private final String algorithmInitializationVector;

    public static EncryptParametersBuilder builder() {
        return new EncryptParametersBuilder();
    }

    public EncryptParameters(int uncompressedSize, int compressedSize, long crc32, String compressedCheckSumType, String compressedCheckSum, String startKeyGenerationName, int startKeySize, String keyDerivationName, int derivedKeySize, int derivationIterationCount, String derivationSalt, String algorithmName, String algorithmInitializationVector) {
        this.uncompressedSize = uncompressedSize;
        this.compressedSize = compressedSize;
        this.crc32 = crc32;
        this.compressedCheckSumType = compressedCheckSumType;
        this.compressedCheckSum = compressedCheckSum;
        this.startKeyGenerationName = startKeyGenerationName;
        this.startKeySize = startKeySize;
        this.keyDerivationName = keyDerivationName;
        this.derivedKeySize = derivedKeySize;
        this.derivationIterationCount = derivationIterationCount;
        this.derivationSalt = derivationSalt;
        this.algorithmName = algorithmName;
        this.algorithmInitializationVector = algorithmInitializationVector;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<manifest:encryption-data");
        util.appendAttribute(appendable, (CharSequence)"manifest:checksum-type", this.compressedCheckSumType);
        util.appendAttribute(appendable, (CharSequence)"manifest:checksum", this.compressedCheckSum);
        appendable.append(">");
        this.appendAlgorithm(util, appendable);
        this.appendKeyDerivation(util, appendable);
        this.appendKeyGeneration(util, appendable);
        appendable.append("</manifest:encryption-data>");
    }

    private void appendAlgorithm(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<manifest:algorithm");
        util.appendAttribute(appendable, (CharSequence)"manifest:algorithm-name", this.algorithmName);
        util.appendAttribute(appendable, (CharSequence)"manifest:initialisation-vector", this.algorithmInitializationVector);
        appendable.append("/>");
    }

    private void appendKeyDerivation(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<manifest:key-derivation");
        util.appendAttribute(appendable, (CharSequence)"manifest:key-derivation-name", this.keyDerivationName);
        util.appendAttribute(appendable, (CharSequence)"manifest:key-size", this.derivedKeySize);
        util.appendAttribute(appendable, (CharSequence)"manifest:iteration-count", this.derivationIterationCount);
        util.appendAttribute(appendable, (CharSequence)"manifest:salt", this.derivationSalt);
        appendable.append("/>");
    }

    private void appendKeyGeneration(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<manifest:start-key-generation");
        util.appendAttribute(appendable, (CharSequence)"manifest:start-key-generation-name", this.startKeyGenerationName);
        util.appendAttribute(appendable, (CharSequence)"manifest:key-size", this.startKeySize);
        appendable.append("/>");
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getCrc32() {
        return this.crc32;
    }
}

