/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.UnregisteredStoredEntry;
import com.github.jferard.fastods.util.CharsetUtil;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.zip.CRC32;

public class MimetypeElement
implements OdsElement {
    public static final String DOCUMENT_MIMETYPE = "application/vnd.oasis.opendocument.spreadsheet";

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        byte[] data = DOCUMENT_MIMETYPE.getBytes(CharsetUtil.UTF_8);
        long crc32 = this.getCrc32(data);
        writer.putNextEntry(new UnregisteredStoredEntry("mimetype", data.length, crc32));
        writer.append(DOCUMENT_MIMETYPE);
        writer.closeEntry();
    }

    private long getCrc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }
}

