/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.HasFooterHeader;
import com.github.jferard.fastods.odselement.MetaElement;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.StandardOdsEntry;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.StylesContainerImpl;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class StylesElement
implements OdsElement {
    public static final Map<String, String> STYLES_NAMESPACE_BY_PREFIX = new HashMap<String, String>();
    private final StylesContainerImpl stylesContainer;

    public StylesElement(StylesContainerImpl stylesContainer) {
        this.stylesContainer = stylesContainer;
    }

    private static void appendDefaultFooterHeaderStyle(XMLUtil util, Appendable appendable, String name) throws IOException {
        appendable.append("<style:style");
        util.appendEAttribute(appendable, "style:name", name);
        util.appendAttribute(appendable, (CharSequence)"style:family", "paragraph");
        util.appendAttribute(appendable, (CharSequence)"style:parent-style-name", "Standard");
        util.appendAttribute(appendable, (CharSequence)"style:class", "extra");
        appendable.append("><style:paragraph-properties");
        util.appendAttribute(appendable, (CharSequence)"text:number-lines", false);
        util.appendAttribute(appendable, (CharSequence)"text:line-number", 0);
        appendable.append("/></style:style>");
    }

    public StylesContainer getStyleTagsContainer() {
        return this.stylesContainer;
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        HasFooterHeader hasFooterHeader = this.stylesContainer.hasFooterHeader();
        writer.putAndRegisterNextEntry(new StandardOdsEntry("styles.xml", "text/xml", null));
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.append("<office:document-styles");
        for (Map.Entry<String, String> entry : STYLES_NAMESPACE_BY_PREFIX.entrySet()) {
            util.appendAttribute((Appendable)writer, (CharSequence)entry.getKey(), entry.getValue());
        }
        util.appendAttribute((Appendable)writer, (CharSequence)"office:version", "1.2");
        writer.append(">");
        this.stylesContainer.writeFontFaceDecls(util, writer);
        writer.append("<office:styles>");
        this.stylesContainer.writeStylesCommonStyles(util, writer);
        this.stylesContainer.writeVisibleDataStyles(util, writer);
        if (hasFooterHeader.hasHeader()) {
            StylesElement.appendDefaultFooterHeaderStyle(util, writer, "Header");
        }
        if (hasFooterHeader.hasFooter()) {
            StylesElement.appendDefaultFooterHeaderStyle(util, writer, "Footer");
        }
        writer.append("</office:styles>");
        writer.append("<office:automatic-styles>");
        this.stylesContainer.writeStylesAutomaticStyles(util, writer);
        this.stylesContainer.writePageLayoutStyles(util, writer);
        writer.append("</office:automatic-styles>");
        writer.append("<office:master-styles>");
        this.stylesContainer.writeMasterPageStyles(util, writer);
        writer.append("</office:master-styles>");
        writer.append("</office:document-styles>");
        writer.closeEntry();
    }

    static {
        STYLES_NAMESPACE_BY_PREFIX.putAll(MetaElement.META_NAMESPACE_BY_PREFIX);
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:presentation", "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:math", "http://www.w3.org/1998/Math/MathML");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:ooow", "http://openoffice.org/2004/writer");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:oooc", "http://openoffice.org/2004/calc");
        STYLES_NAMESPACE_BY_PREFIX.put("xmlns:dom", "http://www.w3.org/2001/xml-events");
    }
}

