/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.regex.Pattern;

public class TableNameUtil {
    private static final char SINGLE_QUOTE = '\'';
    private static final String FORBIDDEN_CHARS = "[]*?:/\\";
    private static final Pattern FORBIDDEN_CHARS_PATTERN = Pattern.compile("[\\[\\]*?:/\\\\]");

    public void checkTableName(CharSequence name) {
        if (name.charAt(0) == '\'') {
            throw new IllegalArgumentException("Table name should not start with ': " + name);
        }
        if (FORBIDDEN_CHARS_PATTERN.matcher(name).find()) {
            throw new IllegalArgumentException("Table name should not contain []*?:/\\: " + name);
        }
    }

    public String sanitizeTableName(CharSequence name) {
        String s = FORBIDDEN_CHARS_PATTERN.matcher(name).replaceAll("_");
        if (s.charAt(0) == '\'') {
            return "_" + s.substring(1);
        }
        return s;
    }

    public String escapeTableName(CharSequence tableName) {
        boolean toQuote = false;
        int apostropheCount = 0;
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (Character.isWhitespace(c) || c == '.') {
                toQuote = true;
                continue;
            }
            if (c != '\'') continue;
            toQuote = true;
            ++apostropheCount;
        }
        StringBuilder sb = new StringBuilder(tableName.length() + (toQuote ? 2 : 0) + apostropheCount);
        if (toQuote) {
            sb.append('\'');
        }
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            sb.append(c);
            if (c != '\'') continue;
            sb.append('\'');
        }
        if (toQuote) {
            sb.append('\'');
        }
        return sb.toString();
    }

    public String unescapeFilename(String filename) throws ParseException, UnsupportedEncodingException {
        return URLDecoder.decode(this.unescapeQuotes(filename), "UTF-8");
    }

    public String unescapeQuotes(String str) throws ParseException {
        int length = str.length();
        if (str.charAt(0) == '\'' && str.charAt(length - 1) == '\'') {
            return this.unescapeEscaped(str.substring(1, length - 1));
        }
        int i = str.indexOf(39);
        if (i != -1) {
            throw new ParseException("Unquoted name " + str, i);
        }
        return str;
    }

    private String unescapeEscaped(String escaped) throws ParseException {
        StringBuilder sb = new StringBuilder();
        int quotes = 0;
        for (int i = 0; i < escaped.length(); ++i) {
            char c = escaped.charAt(i);
            if (c == '\'') {
                if (++quotes != 2) continue;
                quotes = 0;
                sb.append('\'');
                continue;
            }
            if (quotes == 1) {
                throw new ParseException("Missing closing quote in filename " + escaped, i);
            }
            sb.append(c);
        }
        if (quotes != 0) {
            throw new ParseException("Random quote in filename", 0);
        }
        return sb.toString();
    }
}

