/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.TagParameters;
import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.style.FontFace;
import com.github.jferard.fastods.style.TextPropertiesBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class TextProperties
implements TagParameters {
    private final Color fontColor;
    private final String fontName;
    private final String fontStyle;
    private final Color fontUnderlineColor;
    private final Underline fontUnderlineStyle;
    private final String fontWeight;
    private final Length fontSizeLength;
    private final double fontSizePercentage;

    public static TextPropertiesBuilder builder() {
        return new TextPropertiesBuilder();
    }

    TextProperties(Color fontColor, String fontName, String fontWeight, String fontStyle, double fontSizePercentage, Length fontSizeLength, Color fontUnderlineColor, Underline fontUnderlineStyle) {
        this.fontColor = fontColor;
        this.fontName = fontName;
        this.fontWeight = fontWeight;
        this.fontStyle = fontStyle;
        this.fontSizePercentage = fontSizePercentage;
        this.fontSizeLength = fontSizeLength;
        this.fontUnderlineColor = fontUnderlineColor;
        this.fontUnderlineStyle = fontUnderlineStyle;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:text-properties");
        if (this.fontWeight != null) {
            util.appendEAttribute(appendable, "fo:font-weight", this.fontWeight);
            util.appendEAttribute(appendable, "style:font-weight-asian", this.fontWeight);
            util.appendEAttribute(appendable, "style:font-weight-complex", this.fontWeight);
        }
        if (this.fontStyle != null) {
            util.appendEAttribute(appendable, "fo:font-style", this.fontStyle);
            util.appendEAttribute(appendable, "style:font-style-asian", this.fontStyle);
            util.appendEAttribute(appendable, "style:font-style-complex", this.fontStyle);
        }
        if (this.fontColor != SimpleColor.NONE) {
            util.appendAttribute(appendable, (CharSequence)"fo:color", this.fontColor);
        }
        if (this.fontName != null) {
            util.appendAttribute(appendable, (CharSequence)"style:font-name", this.fontName);
        }
        if (this.fontSizePercentage > 0.0) {
            String fontSize = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(this.fontSizePercentage) + "%";
            util.appendAttribute(appendable, (CharSequence)"fo:font-size", fontSize);
            util.appendAttribute(appendable, (CharSequence)"style:font-size-asian", fontSize);
            util.appendAttribute(appendable, (CharSequence)"style:font-size-complex", fontSize);
        } else if (this.fontSizeLength != null) {
            util.appendAttribute(appendable, (CharSequence)"fo:font-size", this.fontSizeLength);
            util.appendAttribute(appendable, (CharSequence)"style:font-size-asian", this.fontSizeLength);
            util.appendAttribute(appendable, (CharSequence)"style:font-size-complex", this.fontSizeLength);
        }
        if (this.fontUnderlineStyle != null) {
            util.appendAttribute(appendable, (CharSequence)"style:text-underline-style", this.fontUnderlineStyle.attrValue);
            util.appendAttribute(appendable, (CharSequence)"style:text-underline-width", "auto");
            String underlineColor = this.fontUnderlineColor == SimpleColor.NONE ? "font-color" : this.fontUnderlineColor.getValue();
            util.appendAttribute(appendable, (CharSequence)"style:text-underline-color", underlineColor);
        }
        appendable.append("/>");
    }

    public boolean isNotEmpty() {
        return this.fontUnderlineStyle != null || this.fontColor != SimpleColor.NONE || this.fontSizePercentage > 0.0 || this.fontSizeLength != null || this.fontStyle != null || this.fontUnderlineColor != SimpleColor.NONE || this.fontWeight != null || this.fontName != null;
    }

    public FontFace getFontFace() {
        if (this.fontName != null) {
            return new FontFace(this.fontName);
        }
        return null;
    }

    public TextPropertiesBuilder toBuilder() {
        return new TextPropertiesBuilder(this.fontColor, this.fontName, this.fontWeight, this.fontStyle, this.fontSizePercentage, this.fontSizeLength, this.fontUnderlineColor, this.fontUnderlineStyle);
    }

    public static enum Underline {
        DASH("dash"),
        DOT_DASH("dot-dash"),
        DOT_DOT_DASH("dot-dot-dash"),
        DOTTED("dotted"),
        LONG_DASH("long-dash"),
        NONE("none"),
        SOLID("solid"),
        WAVE("wave");

        private final String attrValue;

        private Underline(String attrValue) {
            this.attrValue = attrValue;
        }
    }
}

