/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.AnonymousOdsFileWriter;
import com.github.jferard.fastods.OdsDocument;
import com.github.jferard.fastods.OdsFactory;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.tool.ResultSetDataWrapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DatabaseExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException, IOException {
        if (args.length != 2) {
            System.err.println("Usage: java -cp path/to/fastods/jar:path/to/jdbc/driver/jar <connection string> <target.ods>");
        }
        String connectionString = args[0];
        String documentName = args[1];
        Connection connection = DriverManager.getConnection(connectionString);
        try {
            OdsFactory odsFactory = OdsFactory.create(Logger.getLogger("database"), Locale.US);
            AnonymousOdsFileWriter writer = odsFactory.createWriter();
            try {
                OdsDocument document = writer.document();
                DatabaseExporter.exportDatabase(connection, document);
            }
            finally {
                writer.saveAs(documentName);
            }
        }
        finally {
            connection.close();
        }
    }

    public static void exportDatabase(DataSource dataSource, OdsDocument document) throws SQLException, IOException {
        Connection conn = dataSource.getConnection();
        try {
            DatabaseExporter.exportDatabase(conn, document);
        }
        finally {
            conn.close();
        }
    }

    public static void exportDatabase(Connection conn, OdsDocument document) throws SQLException, IOException {
        DatabaseMetaData metaData = conn.getMetaData();
        ResultSet rs = metaData.getTables(null, "", null, null);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (rs.next()) {
            tableNames.add(rs.getString(3));
        }
        Statement statement = conn.createStatement();
        for (String tableName : tableNames) {
            ResultSet tableRs = statement.executeQuery("SELECT * FROM " + tableName);
            Table table = document.addTable(tableName);
            ResultSetDataWrapper wrapper = ResultSetDataWrapper.builder(tableName, tableRs).build();
            table.getWalker().addData(wrapper);
        }
    }
}

