/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.attribute.AttributeValue;
import com.github.jferard.fastods.util.FastOdsXMLEscaper;
import com.github.jferard.fastods.util.XMLEscaper;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class XMLUtil {
    public static final String XML_PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final char SPACE_CHAR = ' ';
    private final XMLEscaper escaper;

    public static XMLUtil create() {
        FastOdsXMLEscaper escaper = FastOdsXMLEscaper.create();
        return new XMLUtil(escaper);
    }

    XMLUtil(XMLEscaper escaper) {
        this.escaper = escaper;
    }

    public void appendEAttribute(Appendable appendable, CharSequence attrName, String attrRawValue) throws IOException {
        appendable.append(' ').append(attrName).append("=\"").append(this.escaper.escapeXMLAttribute(attrRawValue)).append('\"');
    }

    public void appendAttribute(Appendable appendable, CharSequence attrName, boolean attrValue) throws IOException {
        this.appendAttribute(appendable, attrName, Boolean.toString(attrValue));
    }

    public void appendAttribute(Appendable appendable, CharSequence attrName, int attrValue) throws IOException {
        this.appendAttribute(appendable, attrName, Integer.toString(attrValue));
    }

    public void appendAttribute(Appendable appendable, CharSequence attrName, CharSequence attrValue) throws IOException {
        appendable.append(' ').append(attrName).append("=\"").append(attrValue).append('\"');
    }

    public void appendAttribute(Appendable appendable, CharSequence attrName, AttributeValue attrValue) throws IOException {
        appendable.append(' ').append(attrName).append("=\"").append(attrValue.getValue()).append('\"');
    }

    public void appendAttribute(Appendable appendable, CharSequence attrName, List<?> attrs, String sep) throws IOException {
        appendable.append(' ').append(attrName).append("=\"");
        if (!attrs.isEmpty()) {
            Iterator<?> it = attrs.iterator();
            appendable.append(it.next().toString());
            while (it.hasNext()) {
                appendable.append(sep).append(it.next().toString());
            }
        }
        appendable.append('\"');
    }

    public void appendTag(Appendable appendable, CharSequence tagName, String content) throws IOException {
        appendable.append('<').append(tagName).append('>').append(this.escaper.escapeXMLContent(content)).append("</").append(tagName).append('>');
    }

    public String escapeXMLAttribute(String s) {
        return this.escaper.escapeXMLAttribute(s);
    }

    public String escapeXMLContent(String s) {
        return this.escaper.escapeXMLContent(s);
    }

    public String formatTimeInterval(long milliseconds) {
        return "PT" + (double)milliseconds / 1000.0 + "S";
    }

    public String formatTimeInterval(long years, long months, long days, long hours, long minutes, double seconds) {
        if (years < 0L || months < 0L || days < 0L || hours < 0L || minutes < 0L || seconds < 0.0) {
            throw new IllegalArgumentException(String.format("Wrong arguments: %d, %d, %d, %d, %d, %f can't be negative", years, months, days, hours, minutes, seconds));
        }
        boolean noDate = years == 0L && months == 0L && days == 0L;
        boolean noTime = hours == 0L && minutes == 0L && seconds == 0.0;
        StringBuilder sb = new StringBuilder().append('P');
        if (years > 0L || noDate && noTime) {
            sb.append(years).append('Y');
        }
        if (months > 0L) {
            sb.append(months).append('M');
        }
        if (days > 0L) {
            sb.append(days).append('D');
        }
        if (noTime) {
            return sb.toString();
        }
        sb.append('T');
        if (hours > 0L) {
            sb.append(hours).append('H');
        }
        if (minutes > 0L) {
            sb.append(minutes).append('M');
        }
        if (seconds > 0.0) {
            sb.append(seconds).append('S');
        }
        return sb.toString();
    }

    public String formatNegTimeInterval(long years, long months, long days, long hours, long minutes, double seconds) {
        return '-' + this.formatTimeInterval(years, months, days, hours, minutes, seconds);
    }
}

