/*
 * Decompiled with CFR 0.152.
 */
package com.github.pbbl;

import java.nio.Buffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;

public abstract class AbstractBufferPool<T extends Buffer>
implements AutoCloseable {
    private static final int HEURISTIC = 3;
    private final NavigableMap<Integer, Deque<T>> buffers = new TreeMap<Integer, Deque<T>>();

    protected abstract T allocate(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T take(int capacity) {
        Optional<Buffer> maybeBuffer;
        NavigableMap<Integer, Deque<T>> navigableMap = this.buffers;
        synchronized (navigableMap) {
            maybeBuffer = this.buffers.tailMap(capacity, true).values().stream().map(Deque::poll).filter(Objects::nonNull).findAny();
        }
        return (T)maybeBuffer.map(buffer -> {
            buffer.clear().limit(capacity);
            return buffer;
        }).orElseGet(() -> this.allocate(capacity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void give(T buffer) {
        NavigableMap<Integer, Deque<T>> navigableMap = this.buffers;
        synchronized (navigableMap) {
            this.buffers.computeIfAbsent(((Buffer)buffer).capacity(), capacity -> new ArrayDeque(3)).offer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NavigableMap<Integer, Deque<T>> navigableMap = this.buffers;
        synchronized (navigableMap) {
            this.buffers.clear();
        }
    }
}

