/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnymertz.wkhtmltopdf.wrapper;

import com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations.WrapperConfig;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.exceptions.PDFExportException;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.page.Page;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.page.PageType;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.params.Param;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.params.Params;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pdf {
    private static final Logger logger = LoggerFactory.getLogger(Pdf.class);
    private static final String STDINOUT = "-";
    private final WrapperConfig wrapperConfig;
    private final Params params;
    private final Params tocParams;
    private final List<Page> pages;
    private boolean hasToc = false;
    private int timeout = 10;
    private File tempDirectory;

    public Pdf() {
        this(new WrapperConfig());
    }

    public Pdf(WrapperConfig wrapperConfig) {
        this.wrapperConfig = wrapperConfig;
        this.params = new Params();
        this.tocParams = new Params();
        this.pages = new ArrayList<Page>();
        logger.info("Initialized with {}", (Object)wrapperConfig);
    }

    @Deprecated
    public void addPage(String source, PageType type) {
        this.pages.add(new Page(source, type));
    }

    public void addPageFromUrl(String source) {
        this.pages.add(new Page(source, PageType.url));
    }

    public void addPageFromString(String source) {
        this.pages.add(new Page(source, PageType.htmlAsString));
    }

    public void addPageFromFile(String source) {
        this.pages.add(new Page(source, PageType.file));
    }

    public void addToc() {
        this.hasToc = true;
    }

    public void addParam(Param param, Param ... params) {
        this.params.add(param, params);
    }

    public void addTocParam(Param param, Param ... params) {
        this.tocParams.add(param, params);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public File saveAs(String path) throws IOException, InterruptedException {
        File file = new File(path);
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.getPDF());
        logger.info("PDF successfully saved in {}", (Object)file.getAbsolutePath());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPDF() throws IOException, InterruptedException, PDFExportException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            String command = this.getCommand();
            logger.debug("Generating pdf with: {}", (Object)command);
            Process process = Runtime.getRuntime().exec(this.getCommandAsArray());
            Future<byte[]> inputStreamToByteArray = executor.submit(this.streamToByteArrayTask(process.getInputStream()));
            Future<byte[]> outputStreamToByteArray = executor.submit(this.streamToByteArrayTask(process.getErrorStream()));
            process.waitFor();
            if (process.exitValue() != 0) {
                byte[] errorStream = this.getFuture(outputStreamToByteArray);
                logger.error("Error while generating pdf: {}", (Object)new String(errorStream));
                throw new PDFExportException(command, process.exitValue(), errorStream, this.getFuture(inputStreamToByteArray));
            }
            logger.debug("Wkhtmltopdf output:\n{}", (Object)new String(this.getFuture(outputStreamToByteArray)));
            logger.info("PDF successfully generated with: {}", (Object)command);
            byte[] byArray = this.getFuture(inputStreamToByteArray);
            return byArray;
        }
        finally {
            logger.debug("Shutting down executor for wkhtmltopdf.");
            executor.shutdownNow();
            this.cleanTempFiles();
        }
    }

    private String[] getCommandAsArray() throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.wrapperConfig.isXvfbEnabled()) {
            commandLine.addAll(this.wrapperConfig.getXvfbConfig().getCommandLine());
        }
        commandLine.add(this.wrapperConfig.getWkhtmltopdfCommand());
        commandLine.addAll(this.params.getParamsAsStringList());
        if (this.hasToc) {
            commandLine.add("toc");
            commandLine.addAll(this.tocParams.getParamsAsStringList());
        }
        for (Page page : this.pages) {
            if (page.getType().equals((Object)PageType.htmlAsString)) {
                File temp = File.createTempFile("java-wkhtmltopdf-wrapper" + UUID.randomUUID().toString(), ".html", this.tempDirectory);
                FileUtils.writeStringToFile((File)temp, (String)page.getSource(), (String)"UTF-8");
                page.setFilePath(temp.getAbsolutePath());
                commandLine.add(temp.getAbsolutePath());
                continue;
            }
            commandLine.add(page.getSource());
        }
        commandLine.add(STDINOUT);
        logger.debug("Command generated: {}", (Object)((Object)commandLine).toString());
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private Callable<byte[]> streamToByteArrayTask(final InputStream input) {
        return new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return IOUtils.toByteArray((InputStream)input);
            }
        };
    }

    private byte[] getFuture(Future<byte[]> future) {
        try {
            return future.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanTempFiles() {
        logger.debug("Cleaning up temporary files...");
        for (Page page : this.pages) {
            if (!page.getType().equals((Object)PageType.htmlAsString)) continue;
            try {
                Path p = Paths.get(page.getFilePath(), new String[0]);
                logger.debug("Delete temp file at: " + page.getFilePath() + " " + Files.deleteIfExists(p));
            }
            catch (IOException ex) {
                logger.warn("Couldn't delete temp file " + page.getFilePath());
            }
        }
    }

    public String getCommand() throws IOException {
        return StringUtils.join((Object[])this.getCommandAsArray(), (String)" ");
    }
}

