package controller;

import java.io.Serializable;

import message.MessageFacesUtil;
import verifier.StringVerifier;


public abstract class AbstractController implements Serializable {
	private static final long serialVersionUID = -7178665766502418261L;
	
	private String titleEdition;
	private String titleNewRegistration;	
	
	public AbstractController(String titleNewRegistration, String titleEdition) {
		
		if(StringVerifier.isBlanck(titleNewRegistration) && StringVerifier.isBlanck(titleEdition)){
			throw new RuntimeException("You must enter at least one name for the page.");
		}
		
		this.titleNewRegistration = titleNewRegistration;
		this.titleEdition = titleEdition;
	}
	
	public AbstractController(String titleNewRegistration) {
		
		if(StringVerifier.isBlanck(titleNewRegistration)){
			throw new RuntimeException("You must enter at least one name for the page.");
		}
		
		this.titleNewRegistration = titleNewRegistration;
		this.titleEdition = "";
	}

	public abstract void start();
	public abstract boolean isEditing();

	
	public String getPageTitle(){
		if(this.isEditing()){
			return MessageFacesUtil.getMessage(titleEdition);
		}else{
			return MessageFacesUtil.getMessage(titleNewRegistration);
		}
	}
}