package dataTable.lazy;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortOrder;

public abstract class LazyDataTable<T> extends LazyDataModel<T> implements Serializable {
	private static final long serialVersionUID = 2552787837743750076L;
	
	@Override
	public List<T> load(int first, int pageSize, String sortField, SortOrder sortOrder,
			Map<String, Object> filters) {

		this.setRowCount(totalSizeObjects());
		
		return objects(first, pageSize);
	}
	
	protected abstract List<T> objects(int first, int pageSize);
	
	protected abstract int totalSizeObjects();
}