package message;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

public class MessageFacesUtil {

	public static void addErrorMessage(String key) {
		
		String message = getMessage(key);
		
		FacesContext.getCurrentInstance().addMessage(null, 
				new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
	}
	
	public static void addInfoMessage(String key) {
		
		String message = getMessage(key);
		
		FacesContext.getCurrentInstance().addMessage(null, 
				new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
	}
		
	//Pega a mensagem do arquivo de mensagens através da chave dela.
	public static String getMessage(String key) {
		FacesContext facesContext = FacesContext.getCurrentInstance();
		String msg = facesContext.getApplication()
				.getResourceBundle(facesContext, "translation").getString(key);
		return msg;
	}
	
}