package select.one.menu;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import verifier.StringVerifier;

public class SelectOneMenuManager<T> implements Serializable {
	private static final long serialVersionUID = 8346045927240977330L;

	private Map<String, String> allLabels = new HashMap<String, String>();
	private Map<String, T> allObjects = new HashMap<String, T>();
	private String objectSelected;

	
	private SelectOneMenuManager() {}
	
	
	public static <T> SelectOneMenuManager<T> create(){
		return new SelectOneMenuManager<T>();
	}	

	public Map<String, String> getLabels() {
		return allLabels;
	}
	public void addObject(String label, T object) {
		this.allLabels.put(label, label);
		this.allObjects.put(label, object);
	}
	public void clearObjects(){
		allLabels.clear();
		setObjectSelected("");
	}

	public String getObjectSelected() {
		return objectSelected;
	}
	public void setObjectSelected(String objectSelected) {
		this.objectSelected = objectSelected;
	}
	
	public T getObject(){
		if (StringVerifier.notBlanck(getObjectSelected()))
			return this.allObjects.get(getObjectSelected());
		else
			return null;
	}
	
}