package date;

import java.time.ZoneId;
import java.util.Date;

/**
 * This class generates instantaneous point on the time-line in a {@link Date}
 * instance.
 * 
 * @author Jhonathan Camacho
 *
 */
public class DateGenerator {

	/**
	 * Returns an instantaneous point on the time-line in a {@link Date}
	 * instance. This method uses the 'America/Sao_Paulo' {@link ZoneId}.
	 * 
	 * @return an instantaneous point on the time-line in a {@link Date}
	 *         instance.
	 */
	public static final Date toInstant() {
		ZoneId saoPauloTimeZone = ZoneId.of("America/Sao_Paulo");
		Date date = Date.from(java.time.ZonedDateTime.now(saoPauloTimeZone).toInstant());

		return date;
	}
}
