package unique.identifier;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * This class generates unique code through an instantaneous point on the
 * time-line.
 * 
 * @author Jhonathan Camacho.
 * @author Jhonys Camacho.
 *
 */
public class UniqueIdentifierGenerator {

	/**
	 * Returns an unique code generated through an instantaneous point on the
	 * time-line.
	 * 
	 * @return an unique code generate through an instantaneous point on the
	 *         time-line. The generated code is formed by the following
	 *         combination: year + month + day + time in nano format.
	 */
	public static String generateUniqueIdentifier() {

		Date date = new Date();
		String format = "dd/MM/yy";

		SimpleDateFormat formatter = new SimpleDateFormat(format);
		String formattedDate = formatter.format(date);

		String[] values = formattedDate.trim().split("/");

		String year = values[2];
		String month = values[1];
		String day = values[0];

		return year + month + day + System.nanoTime();
	}

}
