package verifier;

import java.util.regex.Pattern;

/**
 * This class verify Cep conditions.
 * 
 * @author Jhonathan Camacho
 *
 */
public class CepVerifier {

	/**
	 * Verify if the cep is valid.
	 * 
	 * @param cep
	 *            the cep that wil be verified.
	 * @return true if the cep is valid. Return false otherwise.
	 */
	public static boolean isValid(String cep) {
		Pattern pattern = Pattern.compile("^[0-9]{8}$");
		return StringVerifier.notBlanck(cep) && pattern.matcher(cep).matches();
	}

	/**
	 * Verify if the cep is invalid.
	 * 
	 * @param cep
	 *            the cep that wil be verified.
	 * @return true if the cep is invalid. Return false otherwise.
	 */
	public static boolean isInvalid(String cep) {
		Pattern pattern = Pattern.compile("^[0-9]{8}$");
		return StringVerifier.isBlanck(cep) || !pattern.matcher(cep).matches();
	}
}
