package verifier;

/**
 * This class verify String conditions.
 * 
 * @author Jhonathan Camacho
 *
 */
public class StringVerifier {
	
	/**
	 * Verify if the string is not blank.
	 * 
	 * @param string the string that will be verified.
	 * 
	 * @return true if the string is not blank. Return false otherwise.
	 */
	public static boolean notBlanck(String string){
		return string != null && !string.trim().isEmpty();
	}
	
	/**
	 * Verify if the string is blank.
	 * 
	 * @param string the string that will be verified.
	 * 
	 * @return true if the string is blank. Return false otherwise.
	 */
	public static boolean isBlanck(String string){		
		return string == null || string.trim().isEmpty();
	}	
}

