/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.util.Properties;
import verifier.StringVerifier;

public class PropertiesLoader {
    public boolean hasPropertiesFile(String propertiesName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream(propertiesName) != null;
    }

    public Properties getPropertiesFile(String propertiesName) {
        Properties properties = null;
        try {
            properties = new Properties();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            properties.load(loader.getResourceAsStream(propertiesName));
        }
        catch (IOException e) {
            throw new FileSystemNotFoundException("Property file '" + propertiesName + "' not found in the classpath.");
        }
        return properties;
    }

    public String getProperty(Properties properties, String propertieKey) {
        this.verifyIfKeyExists(properties, propertieKey);
        return properties.getProperty(propertieKey);
    }

    private boolean verifyIfKeyExists(Properties properties, String propertieKey) {
        if (StringVerifier.isBlanck(propertieKey)) {
            throw new IllegalArgumentException("The key '" + propertieKey + "' is blanck.");
        }
        if (!properties.containsKey(propertieKey)) {
            throw new IllegalArgumentException("The key '" + propertieKey + "' doesn't exist.");
        }
        return true;
    }

    public boolean verifyIfValueExists(Properties properties, String propertieValue) {
        if (StringVerifier.isBlanck(this.getProperty(properties, propertieValue))) {
            throw new IllegalArgumentException("The value '" + propertieValue + "' doesn't exist.");
        }
        return true;
    }
}

