/*
 * Decompiled with CFR 0.152.
 */
package com.github.ji4597056;

import com.github.ji4597056.WsHandlerRegistration;
import com.github.ji4597056.server.AbstractWsServerHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class DefaultWsHandlerRegistration
implements WsHandlerRegistration {
    private Map<String, AbstractWsServerHandler> handlerMap = Collections.synchronizedMap(new HashMap(5));
    private Map<String, HandshakeInterceptor> interceptorMap = Collections.synchronizedMap(new HashMap(5));

    @Override
    public void addHandler(AbstractWsServerHandler ... handlers) {
        Arrays.stream(handlers).forEach(handler -> this.handlerMap.putIfAbsent(((Object)handler).getClass().getName(), (AbstractWsServerHandler)((Object)handler)));
    }

    @Override
    public void addInterceptor(HandshakeInterceptor ... interceptors) {
        Arrays.stream(interceptors).forEach(interceptor -> this.interceptorMap.putIfAbsent(interceptor.getClass().getName(), (HandshakeInterceptor)interceptor));
    }

    @Override
    public AbstractWsServerHandler getHandler(String handlerClassName) {
        return this.handlerMap.get(handlerClassName);
    }

    @Override
    public HandshakeInterceptor getInterceptor(String interceptorClassName) {
        return this.interceptorMap.get(interceptorClassName);
    }
}

