/*
 * Decompiled with CFR 0.152.
 */
package com.github.ji4597056;

import com.github.ji4597056.DefaultWsHandlerRegistration;
import com.github.ji4597056.WsForwardProperties;
import com.github.ji4597056.WsHandlerRegistration;
import com.github.ji4597056.server.AbstractWsServerHandler;
import com.github.ji4597056.server.DiscoveryForwardHandler;
import com.github.ji4597056.utils.CommonUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocket
@ConditionalOnProperty(prefix="ws.forward", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={WsForwardProperties.class})
public class WsForwardConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsForwardConfiguration.class);
    @Autowired
    private WsForwardProperties wsForwardProperties;
    @Autowired(required=false)
    private DiscoveryClient discoveryClient;

    @Bean
    @ConditionalOnMissingBean(value={AbstractWsServerHandler.class})
    public AbstractWsServerHandler discoveryForwardHandler() {
        return new DiscoveryForwardHandler(this.discoveryClient, this.wsForwardProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={WsHandlerRegistration.class})
    public WsHandlerRegistration wsHandlerRegistration() {
        return new DefaultWsHandlerRegistration();
    }

    @Configuration
    @AutoConfigureAfter(value={WsHandlerRegistration.class, AbstractWsServerHandler.class})
    protected class WebsocketConfig
    implements WebSocketConfigurer {
        @Autowired
        private WsHandlerRegistration handlerRegistration;
        @Autowired(required=false)
        private List<HandshakeInterceptor> defaultInterceptors;
        @Autowired
        private AbstractWsServerHandler defaultHandler;

        protected WebsocketConfig() {
        }

        public void registerWebSocketHandlers(WebSocketHandlerRegistry webSocketHandlerRegistry) {
            Map<String, WsForwardProperties.ForwardHandler> handlers = WsForwardConfiguration.this.wsForwardProperties.getHandlers();
            if (handlers != null && !handlers.isEmpty()) {
                WsForwardConfiguration.this.wsForwardProperties.getHandlers().forEach((id, handler) -> {
                    if (handler.isEnabled()) {
                        this.registryHandler(webSocketHandlerRegistry, (WsForwardProperties.ForwardHandler)handler);
                    }
                });
            }
        }

        private void registryHandler(WebSocketHandlerRegistry registry, WsForwardProperties.ForwardHandler handler) {
            WebSocketHandlerRegistration registration = this.getRegistration(registry, handler);
            if (handler.getAllowedOrigins() == null) {
                registration.setAllowedOrigins(new String[]{"*"});
            } else {
                registration.setAllowedOrigins(handler.getAllowedOrigins());
            }
            String[] interceptorClasses = handler.getInterceptorClasses();
            if (interceptorClasses != null) {
                HandshakeInterceptor[] interceptors = (HandshakeInterceptor[])Arrays.stream(interceptorClasses).map(className -> this.handlerRegistration.getInterceptor((String)className)).toArray(HandshakeInterceptor[]::new);
                registration.addInterceptors(interceptors);
            } else if (this.defaultInterceptors != null) {
                registration.addInterceptors(this.defaultInterceptors.toArray(new HandshakeInterceptor[this.defaultInterceptors.size()]));
            }
            if (handler.isWithJs()) {
                registration.withSockJS();
            }
        }

        private WebSocketHandlerRegistration getRegistration(WebSocketHandlerRegistry registry, WsForwardProperties.ForwardHandler handler) {
            String className = handler.getHandlerClass();
            if (className == null) {
                return registry.addHandler((WebSocketHandler)this.defaultHandler, new String[]{CommonUtils.getWsPattern(handler)});
            }
            try {
                return registry.addHandler((WebSocketHandler)this.handlerRegistration.getHandler(handler.getHandlerClass()), new String[]{CommonUtils.getWsPattern(handler)});
            }
            catch (Exception e) {
                LOGGER.error("Set webosocket handler error!error: {}", (Throwable)e);
                throw new IllegalArgumentException("Set websocket handler error!");
            }
        }
    }
}

