/*
 * Decompiled with CFR 0.152.
 */
package com.github.ji4597056;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="ws.forward")
public class WsForwardProperties {
    private static final String URL_START_PREFIX = "/";
    private boolean enabled = true;
    private Map<String, ForwardHandler> handlers = new HashMap<String, ForwardHandler>(5);

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, ForwardHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Map<String, ForwardHandler> handlers) {
        this.handlers = handlers;
    }

    @PostConstruct
    public void init() {
        this.handlers.forEach((key, handler) -> {
            if (!StringUtils.hasText((String)handler.getId())) {
                ((ForwardHandler)handler).id = key;
            }
        });
    }

    public static class ForwardHandler {
        private boolean enabled = true;
        private String id;
        private String prefix;
        private String forwardPrefix;
        private String uri;
        private String serviceId;
        private boolean withJs;
        private String[] listOfServers;
        private String[] allowedOrigins;
        private String handlerClass;
        private String[] interceptorClasses;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPrefix() {
            if (this.prefix == null || this.prefix.startsWith(WsForwardProperties.URL_START_PREFIX)) {
                return this.prefix;
            }
            return WsForwardProperties.URL_START_PREFIX + this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getForwardPrefix() {
            if (this.forwardPrefix == null || this.forwardPrefix.startsWith(WsForwardProperties.URL_START_PREFIX)) {
                return this.forwardPrefix;
            }
            return WsForwardProperties.URL_START_PREFIX + this.forwardPrefix;
        }

        public void setForwardPrefix(String forwardPrefix) {
            this.forwardPrefix = forwardPrefix;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public boolean isWithJs() {
            return this.withJs;
        }

        public void setWithJs(boolean withJs) {
            this.withJs = withJs;
        }

        public String[] getListOfServers() {
            return this.listOfServers;
        }

        public void setListOfServers(String[] listOfServers) {
            this.listOfServers = listOfServers;
        }

        public String[] getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public String getHandlerClass() {
            return this.handlerClass;
        }

        public void setHandlerClass(String handlerClass) {
            this.handlerClass = handlerClass;
        }

        public String[] getInterceptorClasses() {
            return this.interceptorClasses;
        }

        public void setInterceptorClasses(String[] interceptorClasses) {
            this.interceptorClasses = interceptorClasses;
        }
    }
}

