/*
 * Decompiled with CFR 0.152.
 */
package com.github.ji4597056.client;

import com.github.ji4597056.MessageFilter;
import com.github.ji4597056.client.WsForwardClientHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class WsForwardClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsForwardClient.class);
    private final String url;
    private final WebSocketSession webSocketSession;
    private final MessageFilter messageFilter;
    private Bootstrap bootstrap;
    private Channel channel;

    private WsForwardClient(String url, WebSocketSession webSocketSession, MessageFilter messageFilter) {
        this.url = url;
        this.webSocketSession = webSocketSession;
        this.messageFilter = messageFilter;
    }

    public void connect() throws Exception {
        URI uri = new URI(this.url);
        String scheme = uri.getScheme();
        final String host = uri.getHost();
        final int port = uri.getPort();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            LOGGER.error("Error websocket scheme!url: {}", (Object)this.url);
            throw new IllegalArgumentException("Only ws(s) is supported.");
        }
        final SslContext sslCtx = this.getSslContext(scheme);
        NioEventLoopGroup group = new NioEventLoopGroup();
        final WsForwardClientHandler handler = new WsForwardClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)new DefaultHttpHeaders()), this.webSocketSession, this.messageFilter);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                if (sslCtx != null) {
                    p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                }
                p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, handler});
            }
        });
        this.channel = this.bootstrap.connect(uri.getHost(), port).sync().channel();
        handler.handshakeFuture().sync();
    }

    public static WsForwardClient create(String url, WebSocketSession webSocketSession, MessageFilter messageFilter) {
        return new WsForwardClient(url, webSocketSession, messageFilter);
    }

    private SslContext getSslContext(String scheme) throws SSLException {
        boolean ssl = "wss".equalsIgnoreCase(scheme);
        if (ssl) {
            return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

