/*
 * Decompiled with CFR 0.152.
 */
package com.github.ji4597056.client;

import com.github.ji4597056.MessageFilter;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WsForwardClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsForwardClientHandler.class);
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketSession webSocketSession;
    private final MessageFilter messageFilter;
    private ChannelPromise handshakeFuture;

    public WsForwardClientHandler(WebSocketClientHandshaker handshaker, WebSocketSession webSocketSession, MessageFilter messageFilter) {
        this.handshaker = handshaker;
        this.webSocketSession = webSocketSession;
        this.messageFilter = messageFilter;
    }

    public ChannelFuture handshakeFuture() {
        return this.handshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ctx.close();
        this.closeWebSocketSession();
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            try {
                this.handshaker.finishHandshake(ch, (FullHttpResponse)msg);
                this.handshakeFuture.setSuccess();
            }
            catch (WebSocketHandshakeException e) {
                LOGGER.info("WebSocket Client failed to connect");
                this.handshakeFuture.setFailure((Throwable)e);
            }
            return;
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse response = (FullHttpResponse)msg;
            throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
        }
        if (msg instanceof CloseWebSocketFrame) {
            this.closeWebSocketSession();
            return;
        }
        Optional.ofNullable(msg).map(frame -> this.messageFilter.toMessage((WebSocketFrame)frame)).filter(message -> message instanceof WebSocketMessage).ifPresent(message -> {
            try {
                this.webSocketSession.sendMessage((WebSocketMessage)message);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error("Websocket forward client caught exception!exception: {}", cause);
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
        this.closeWebSocketSession();
    }

    private void closeWebSocketSession() {
        if (this.webSocketSession.isOpen()) {
            try {
                this.webSocketSession.close();
            }
            catch (IOException e) {
                LOGGER.error("Close websocket session error!error: {}", (Throwable)e);
            }
        }
    }
}

