/*
 * Decompiled with CFR 0.152.
 */
package com.github.ji4597056.server;

import com.github.ji4597056.DefaultMessageFilter;
import com.github.ji4597056.MessageFilter;
import com.github.ji4597056.client.WsForwardClient;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.AbstractWebSocketMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.AbstractWebSocketHandler;

public abstract class AbstractWsServerHandler
extends AbstractWebSocketHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWsServerHandler.class);
    private static final Map<String, Channel> CHANNELS = new ConcurrentHashMap<String, Channel>(100);
    private MessageFilter messageFilter = new DefaultMessageFilter();

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        Optional.ofNullable(this.messageFilter.fromMessage((AbstractWebSocketMessage)message)).ifPresent(msg -> CHANNELS.get(session.getId()).writeAndFlush(msg));
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        WsForwardClient client = WsForwardClient.create(this.getForwardUrl(session), session, this.messageFilter);
        client.connect();
        Channel channel = client.getChannel();
        CHANNELS.put(session.getId(), channel);
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        if (session.isOpen()) {
            session.close();
        }
        this.closeGracefully(session);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        this.closeGracefully(session);
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public abstract String getForwardUrl(WebSocketSession var1);

    public MessageFilter getMessageFilter() {
        return this.messageFilter;
    }

    public void setMessageFilter(MessageFilter messageFilter) {
        this.messageFilter = messageFilter;
    }

    private void closeGracefully(WebSocketSession session) {
        Optional.ofNullable(CHANNELS.get(session.getId())).ifPresent(channel -> {
            try {
                if (channel.isOpen()) {
                    channel.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Close websocket forward client error!error: {}", (Throwable)e);
            }
        });
        CHANNELS.remove(session.getId());
    }
}

