/*
 * Decompiled with CFR 0.152.
 */
package com.github.ji4597056.server;

import com.github.ji4597056.WsForwardProperties;
import com.github.ji4597056.server.AbstractWsServerHandler;
import com.github.ji4597056.utils.CommonUtils;
import io.netty.util.CharsetUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.util.UriUtils;

public class DiscoveryForwardHandler
extends AbstractWsServerHandler {
    private volatile boolean dirty = true;
    private Map<String, ServiceHandler> serviceMap = new ConcurrentHashMap<String, ServiceHandler>();
    private PathMatcher matcher = new AntPathMatcher();
    private DiscoveryClient discoveryClient;
    private WsForwardProperties wsForwardProperties;

    public DiscoveryForwardHandler(DiscoveryClient discoveryClient, WsForwardProperties wsForwardProperties) {
        this.discoveryClient = discoveryClient;
        this.wsForwardProperties = wsForwardProperties;
    }

    @Override
    public String getForwardUrl(WebSocketSession session) {
        this.init();
        ServiceHandler handler = this.getServiceId(session.getUri().getPath());
        String address = this.getLoadBalanceInstance(handler);
        return this.getWsForwardUrl(address, handler, session.getUri());
    }

    private String getWsForwardUrl(String address, ServiceHandler handler, URI uri) {
        String prefix = Optional.ofNullable(handler.getForwardPrefix()).orElse("/");
        try {
            String query = UriUtils.encodeQuery((String)uri.getQuery(), (String)CharsetUtil.UTF_8.name());
            String url = UriUtils.encodePath((String)(handler.getPrefix() == null ? uri.getPath() : uri.getPath().substring(handler.getPrefix().length())), (String)CharsetUtil.UTF_8.name());
            if (query == null) {
                return "ws:/" + prefix + address + url;
            }
            return "ws:/" + prefix + address + url + "?" + query;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private ServiceHandler getServiceId(String uri) {
        return this.serviceMap.entrySet().stream().filter(entry -> this.matcher.match((String)entry.getKey(), uri)).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new IllegalStateException("Can't find matching patterns for " + uri));
    }

    private String getLoadBalanceInstance(ServiceHandler handler) {
        List<String> addresses;
        if (this.discoveryClient != null && handler.getServiceId() != null) {
            List instances = this.discoveryClient.getInstances(handler.getServiceId());
            if (instances == null || instances.isEmpty()) {
                throw new IllegalStateException("Can't find service id for " + handler.getId());
            }
            addresses = instances.stream().map(instance -> instance.getHost() + ":" + instance.getPort()).collect(Collectors.toList());
        } else if (handler.getListOfServers() != null && handler.getListOfServers().length > 0) {
            addresses = Arrays.asList(handler.getListOfServers());
        } else {
            throw new IllegalStateException("Can't find service id or listOfServers for " + handler.getId());
        }
        return addresses.get(CommonUtils.getLoadBlanceIndex(handler.getCounter(), addresses.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.dirty) {
            DiscoveryForwardHandler discoveryForwardHandler = this;
            synchronized (discoveryForwardHandler) {
                if (this.dirty) {
                    this.wsForwardProperties.getHandlers().forEach((id, handler) -> {
                        if (handler.isEnabled()) {
                            this.serviceMap.put(CommonUtils.getWsPattern(handler), new ServiceHandler((String)id, handler.getServiceId(), handler.getListOfServers(), handler.getPrefix(), handler.getForwardPrefix()));
                        }
                    });
                    this.dirty = false;
                }
            }
        }
    }

    static class ServiceHandler {
        private final String id;
        private final AtomicInteger counter;
        private final String serviceId;
        private final String[] listOfServers;
        private final String prefix;
        private final String forwardPrefix;

        public ServiceHandler(String id, String serviceId, String[] listOfServers, String prefix, String forwardPrefix) {
            this.id = id;
            this.serviceId = serviceId;
            this.listOfServers = listOfServers;
            this.prefix = prefix;
            this.forwardPrefix = forwardPrefix;
            this.counter = new AtomicInteger();
        }

        public String getId() {
            return this.id;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public String[] getListOfServers() {
            return this.listOfServers;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getForwardPrefix() {
            return this.forwardPrefix;
        }

        public AtomicInteger getCounter() {
            return this.counter;
        }
    }
}

