/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputChecker;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestChecksumFileSystem {
    static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data/work-dir/localfs");
    static LocalFileSystem localFs;

    @Before
    public void resetLocalFs() throws Exception {
        localFs = FileSystem.getLocal((Configuration)new Configuration());
        localFs.setVerifyChecksum(true);
    }

    @Test
    public void testgetChecksumLength() throws Exception {
        Assert.assertEquals((long)8L, (long)ChecksumFileSystem.getChecksumLength((long)0L, (int)512));
        Assert.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)1L, (int)512));
        Assert.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)512L, (int)512));
        Assert.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)513L, (int)512));
        Assert.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1023L, (int)512));
        Assert.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1024L, (int)512));
        Assert.assertEquals((long)408L, (long)ChecksumFileSystem.getChecksumLength((long)100L, (int)1));
        Assert.assertEquals((long)4000000000008L, (long)ChecksumFileSystem.getChecksumLength((long)10000000000000L, (int)10));
    }

    @Test
    public void testVerifyChecksum() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testPath");
        Path testPath11 = new Path(TEST_ROOT_DIR, "testPath11");
        FSDataOutputStream fout = localFs.create(testPath);
        fout.write("testing".getBytes());
        fout.close();
        fout = localFs.create(testPath11);
        fout.write("testing you".getBytes());
        fout.close();
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 128);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 511);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 512);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 513);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1023);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1025);
        localFs.delete(localFs.getChecksumFile(testPath), true);
        Assert.assertTrue((String)"checksum deleted", (!localFs.exists(localFs.getChecksumFile(testPath)) ? 1 : 0) != 0);
        FileUtil.copy((FileSystem)localFs, (Path)localFs.getChecksumFile(testPath11), (FileSystem)localFs, (Path)localFs.getChecksumFile(testPath), (boolean)false, (boolean)true, (Configuration)localFs.getConf());
        Assert.assertTrue((String)"checksum exists", (boolean)localFs.exists(localFs.getChecksumFile(testPath)));
        boolean errorRead = false;
        try {
            FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        }
        catch (ChecksumException ie) {
            errorRead = true;
        }
        Assert.assertTrue((String)"error reading", (boolean)errorRead);
        localFs.setVerifyChecksum(false);
        String str = FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024).toString();
        Assert.assertTrue((String)"read", (boolean)"testing".equals(str));
    }

    @Test
    public void testMultiChunkFile() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testMultiChunk");
        FSDataOutputStream fout = localFs.create(testPath);
        for (int i = 0; i < 1000; ++i) {
            fout.write(("testing" + i).getBytes());
        }
        fout.close();
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 128);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 511);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 512);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 513);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1023);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1025);
    }

    @Test
    public void testTruncatedChecksum() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testtruncatedcrc");
        FSDataOutputStream fout = localFs.create(testPath);
        fout.write("testing truncation".getBytes());
        fout.close();
        Path checksumFile = localFs.getChecksumFile(testPath);
        FileSystem rawFs = localFs.getRawFileSystem();
        FSDataInputStream checksumStream = rawFs.open(checksumFile);
        byte[] buf = new byte[8192];
        int read = checksumStream.read(buf, 0, buf.length);
        checksumStream.close();
        FSDataOutputStream replaceStream = rawFs.create(checksumFile);
        replaceStream.write(buf, 0, read - 1);
        replaceStream.close();
        try {
            FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
            Assert.fail((String)"Did not throw a ChecksumException when reading truncated crc file");
        }
        catch (ChecksumException ie) {
            // empty catch block
        }
        localFs.setVerifyChecksum(false);
        String str = FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024).toString();
        Assert.assertTrue((String)"read", (boolean)"testing truncation".equals(str));
    }

    @Test
    public void testStreamType() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testStreamType");
        localFs.create(testPath).close();
        FSDataInputStream in = null;
        localFs.setVerifyChecksum(true);
        in = localFs.open(testPath);
        Assert.assertTrue((String)"stream is input checker", (boolean)(in.getWrappedStream() instanceof FSInputChecker));
        localFs.setVerifyChecksum(false);
        in = localFs.open(testPath);
        Assert.assertFalse((String)"stream is not input checker", (boolean)(in.getWrappedStream() instanceof FSInputChecker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorruptedChecksum() throws Exception {
        Path testPath = new Path(TEST_ROOT_DIR, "testCorruptChecksum");
        Path checksumPath = localFs.getChecksumFile(testPath);
        FSDataOutputStream out = localFs.create(testPath, true);
        out.write("testing 1 2 3".getBytes());
        out.close();
        Assert.assertTrue((boolean)localFs.exists(checksumPath));
        FileStatus stat = localFs.getFileStatus(checksumPath);
        out = localFs.getRawFileSystem().create(testPath, true);
        out.write("testing stale checksum".getBytes());
        out.close();
        Assert.assertTrue((boolean)localFs.exists(checksumPath));
        Assert.assertEquals((Object)stat, (Object)localFs.getFileStatus(checksumPath));
        ChecksumException e = null;
        try {
            localFs.setVerifyChecksum(true);
            FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        }
        catch (ChecksumException ce) {
            e = ce;
        }
        finally {
            Assert.assertNotNull((String)"got checksum error", (Object)((Object)e));
        }
        localFs.setVerifyChecksum(false);
        String str = FileSystemTestHelper.readFile((FileSystem)localFs, testPath, 1024);
        Assert.assertEquals((Object)"testing stale checksum", (Object)str);
    }

    @Test
    public void testRenameFileToFile() throws Exception {
        Path srcPath = new Path(TEST_ROOT_DIR, "testRenameSrc");
        Path dstPath = new Path(TEST_ROOT_DIR, "testRenameDst");
        this.verifyRename(srcPath, dstPath, false);
    }

    @Test
    public void testRenameFileIntoDir() throws Exception {
        Path srcPath = new Path(TEST_ROOT_DIR, "testRenameSrc");
        Path dstPath = new Path(TEST_ROOT_DIR, "testRenameDir");
        localFs.mkdirs(dstPath);
        this.verifyRename(srcPath, dstPath, true);
    }

    @Test
    public void testRenameFileIntoDirFile() throws Exception {
        Path srcPath = new Path(TEST_ROOT_DIR, "testRenameSrc");
        Path dstPath = new Path(TEST_ROOT_DIR, "testRenameDir/testRenameDst");
        Assert.assertTrue((boolean)localFs.mkdirs(dstPath));
        this.verifyRename(srcPath, dstPath, false);
    }

    void verifyRename(Path srcPath, Path dstPath, boolean dstIsDir) throws Exception {
        localFs.delete(srcPath, true);
        localFs.delete(dstPath, true);
        Path realDstPath = dstPath;
        if (dstIsDir) {
            localFs.mkdirs(dstPath);
            realDstPath = new Path(dstPath, srcPath.getName());
        }
        FileSystemTestHelper.writeFile((FileSystem)localFs, srcPath, 1);
        Assert.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(srcPath)));
        Assert.assertTrue((boolean)localFs.rename(srcPath, dstPath));
        Assert.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(realDstPath)));
        FileSystemTestHelper.writeFile(localFs.getRawFileSystem(), srcPath, 1);
        Assert.assertFalse((boolean)localFs.exists(localFs.getChecksumFile(srcPath)));
        Assert.assertTrue((boolean)localFs.rename(srcPath, dstPath));
        Assert.assertFalse((boolean)localFs.exists(localFs.getChecksumFile(realDstPath)));
        FileSystemTestHelper.writeFile((FileSystem)localFs, srcPath, 1);
        Assert.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(srcPath)));
        Assert.assertTrue((boolean)localFs.rename(srcPath, dstPath));
        Assert.assertTrue((boolean)localFs.exists(localFs.getChecksumFile(realDstPath)));
    }

    @Test
    public void testSetPermissionCrc() throws Exception {
        FileSystem rawFs = localFs.getRawFileSystem();
        Path p = new Path(TEST_ROOT_DIR, "testCrcPermissions");
        localFs.createNewFile(p);
        Path crc = localFs.getChecksumFile(p);
        assert (rawFs.exists(crc));
        for (short mode : Arrays.asList((short)438, (short)432, (short)384)) {
            FsPermission perm = new FsPermission(mode);
            localFs.setPermission(p, perm);
            Assert.assertEquals((Object)perm, (Object)localFs.getFileStatus(p).getPermission());
            Assert.assertEquals((Object)perm, (Object)rawFs.getFileStatus(crc).getPermission());
        }
    }
}

