/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.TFile;
import org.junit.Assert;

public class TestTFileUnsortedByteArrays
extends TestCase {
    private static String ROOT = System.getProperty("test.build.data", "/tmp/tfile-test");
    private static final int BLOCK_SIZE = 512;
    private static final int BUF_SIZE = 64;
    private FileSystem fs;
    private Configuration conf;
    private Path path;
    private FSDataOutputStream out;
    private TFile.Writer writer;
    private String compression = Compression.Algorithm.GZ.getName();
    private String outputFile = "TFileTestUnsorted";
    private int records1stBlock = 4314;
    private int records2ndBlock = 4108;

    public void init(String compression, String outputFile, int numRecords1stBlock, int numRecords2ndBlock) {
        this.compression = compression;
        this.outputFile = outputFile;
        this.records1stBlock = numRecords1stBlock;
        this.records2ndBlock = numRecords2ndBlock;
    }

    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile);
        this.fs = this.path.getFileSystem(this.conf);
        this.out = this.fs.create(this.path);
        this.writer = new TFile.Writer(this.out, 512, this.compression, null, this.conf);
        this.writer.append("keyZ".getBytes(), "valueZ".getBytes());
        this.writer.append("keyM".getBytes(), "valueM".getBytes());
        this.writer.append("keyN".getBytes(), "valueN".getBytes());
        this.writer.append("keyA".getBytes(), "valueA".getBytes());
        this.closeOutput();
    }

    public void tearDown() throws IOException {
        this.fs.delete(this.path, true);
    }

    public void testFailureScannerWithKeys() throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        Assert.assertFalse((boolean)reader.isSorted());
        Assert.assertEquals((long)((int)reader.getEntryCount()), (long)4L);
        try {
            TFile.Reader.Scanner scanner = reader.createScannerByKey("aaa".getBytes(), "zzz".getBytes());
            Assert.fail((String)"Failed to catch creating scanner with keys on unsorted file.");
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScan() throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        Assert.assertFalse((boolean)reader.isSorted());
        Assert.assertEquals((long)((int)reader.getEntryCount()), (long)4L);
        TFile.Reader.Scanner scanner = reader.createScanner();
        try {
            byte[] kbuf = new byte[64];
            int klen = scanner.entry().getKeyLength();
            scanner.entry().getKey(kbuf);
            Assert.assertEquals((Object)new String(kbuf, 0, klen), (Object)"keyZ");
            byte[] vbuf = new byte[64];
            int vlen = scanner.entry().getValueLength();
            scanner.entry().getValue(vbuf);
            Assert.assertEquals((Object)new String(vbuf, 0, vlen), (Object)"valueZ");
            scanner.advance();
            vbuf = new byte[64];
            vlen = scanner.entry().getValueLength();
            scanner.entry().getValue(vbuf);
            Assert.assertEquals((Object)new String(vbuf, 0, vlen), (Object)"valueM");
            kbuf = new byte[64];
            klen = scanner.entry().getKeyLength();
            scanner.entry().getKey(kbuf);
            Assert.assertEquals((Object)new String(kbuf, 0, klen), (Object)"keyM");
        }
        finally {
            scanner.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScanRange() throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        Assert.assertFalse((boolean)reader.isSorted());
        Assert.assertEquals((long)((int)reader.getEntryCount()), (long)4L);
        TFile.Reader.Scanner scanner = reader.createScanner();
        try {
            byte[] kbuf = new byte[64];
            int klen = scanner.entry().getKeyLength();
            scanner.entry().getKey(kbuf);
            Assert.assertEquals((Object)new String(kbuf, 0, klen), (Object)"keyZ");
            byte[] vbuf = new byte[64];
            int vlen = scanner.entry().getValueLength();
            scanner.entry().getValue(vbuf);
            Assert.assertEquals((Object)new String(vbuf, 0, vlen), (Object)"valueZ");
            scanner.advance();
            vbuf = new byte[64];
            vlen = scanner.entry().getValueLength();
            scanner.entry().getValue(vbuf);
            Assert.assertEquals((Object)new String(vbuf, 0, vlen), (Object)"valueM");
            kbuf = new byte[64];
            klen = scanner.entry().getKeyLength();
            scanner.entry().getKey(kbuf);
            Assert.assertEquals((Object)new String(kbuf, 0, klen), (Object)"keyM");
        }
        finally {
            scanner.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailureSeek() throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        TFile.Reader.Scanner scanner = reader.createScanner();
        try {
            try {
                scanner.lowerBound("keyN".getBytes());
                Assert.fail((String)"Cannot search in a unsorted TFile!");
            }
            catch (Exception e) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            try {
                scanner.upperBound("keyA".getBytes());
                Assert.fail((String)"Cannot search higher in a unsorted TFile!");
            }
            catch (Exception e) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            try {
                scanner.seekTo("keyM".getBytes());
                Assert.fail((String)"Cannot search a unsorted TFile!");
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        finally {
            scanner.close();
            reader.close();
        }
    }

    private void closeOutput() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
            this.out.close();
            this.out = null;
        }
    }
}

