/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.UnreliableImplementation;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRetryProxy {
    private UnreliableImplementation unreliableImpl;

    @Before
    public void setUp() throws Exception {
        this.unreliableImpl = new UnreliableImplementation();
    }

    @Test
    public void testTryOnceThenFail() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL);
        unreliable.alwaysSucceeds();
        try {
            unreliable.failsOnceThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testRpcInvocation() throws Exception {
        final UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.RETRY_FOREVER);
        Assert.assertTrue((boolean)RetryInvocationHandler.isRpcInvocation((Object)unreliable));
        ProtocolTranslator xlator = new ProtocolTranslator(){
            int count = 0;

            public Object getUnderlyingProxyObject() {
                ++this.count;
                return unreliable;
            }

            public String toString() {
                return "" + this.count;
            }
        };
        Assert.assertTrue((boolean)RetryInvocationHandler.isRpcInvocation((Object)xlator));
        Assert.assertEquals((Object)xlator.toString(), (Object)"1");
        Assert.assertFalse((boolean)RetryInvocationHandler.isRpcInvocation((Object)new Object()));
    }

    @Test
    public void testRetryForever() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.RETRY_FOREVER);
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        unreliable.failsTenTimesThenSucceeds();
    }

    @Test
    public void testRetryUpToMaximumCountWithFixedSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)8, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryUpToMaximumTimeWithFixedSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)80L, (long)10L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryUpToMaximumCountWithProportionalSleep() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumCountWithProportionalSleep((int)8, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testExponentialRetry() throws UnreliableInterface.UnreliableException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.exponentialBackoffRetry((int)5, (long)1L, (TimeUnit)TimeUnit.NANOSECONDS));
        unreliable.alwaysSucceeds();
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.failsTenTimesThenSucceeds();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryByException() throws UnreliableInterface.UnreliableException {
        Map<Class<UnreliableInterface.FatalException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryByException((RetryPolicy)RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        unreliable.failsOnceThenSucceeds();
        try {
            unreliable.alwaysFailsWithFatalException();
            Assert.fail((String)"Should fail");
        }
        catch (UnreliableInterface.FatalException fatalException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryByRemoteException() {
        Map<Class<UnreliableInterface.FatalException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(UnreliableInterface.FatalException.class, RetryPolicies.TRY_ONCE_THEN_FAIL);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryByRemoteException((RetryPolicy)RetryPolicies.RETRY_FOREVER, exceptionToPolicyMap));
        try {
            unreliable.alwaysFailsWithRemoteFatalException();
            Assert.fail((String)"Should fail");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryOtherThanRemoteException() throws Throwable {
        Map<Class<IOException>, RetryPolicy> exceptionToPolicyMap = Collections.singletonMap(IOException.class, RetryPolicies.RETRY_FOREVER);
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryOtherThanRemoteException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap));
        unreliable.failsOnceWithIOException();
        try {
            unreliable.failsOnceWithRemoteException();
            Assert.fail((String)"Should fail");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Test
    public void testRetryInterruptible() throws Throwable {
        final UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, (Object)this.unreliableImpl, (RetryPolicy)RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)10L, (long)10L, (TimeUnit)TimeUnit.SECONDS));
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference futureThread = new AtomicReference();
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Throwable> future = exec.submit(new Callable<Throwable>(){

            @Override
            public Throwable call() throws Exception {
                futureThread.set(Thread.currentThread());
                latch.countDown();
                try {
                    unreliable.alwaysFailsWithFatalException();
                }
                catch (UndeclaredThrowableException ute) {
                    return ute.getCause();
                }
                return null;
            }
        });
        latch.await();
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)((Thread)futureThread.get()).isAlive());
        ((Thread)futureThread.get()).interrupt();
        Throwable e = future.get(1L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)e);
        Assert.assertEquals(InterruptedException.class, e.getClass());
        Assert.assertEquals((Object)"sleep interrupted", (Object)e.getMessage());
    }
}

