/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenManager;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZKDelegationTokenSecretManager {
    private static final int TEST_RETRIES = 2;
    private static final int RETRY_COUNT = 5;
    private static final int RETRY_WAIT = 1000;
    private static final long DAY_IN_SECS = 86400L;
    private TestingServer zkServer;

    @Before
    public void setup() throws Exception {
        this.zkServer = new TestingServer();
        this.zkServer.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.zkServer != null) {
            this.zkServer.close();
        }
    }

    protected Configuration getSecretConf(String connectString) {
        Configuration conf = new Configuration();
        conf.setBoolean("zk-dt-secret-manager.enable", true);
        conf.set("zk-dt-secret-manager.zkConnectionString", connectString);
        conf.set("zk-dt-secret-manager.znodeWorkingPath", "testPath");
        conf.set("zk-dt-secret-manager.zkAuthType", "none");
        conf.setLong("zk-dt-secret-manager.zkShutdownTimeout", 100L);
        conf.setLong("delegation-token.update-interval.sec", 86400L);
        conf.setLong("delegation-token.max-lifetime.sec", 86400L);
        conf.setLong("delegation-token.renew-interval.sec", 86400L);
        conf.setLong("delegation-token.removal-scan-interval.sec", 86400L);
        return conf;
    }

    @Test
    public void testMultiNodeOperations() throws Exception {
        for (int i = 0; i < 2; ++i) {
            DelegationTokenManager tm2 = null;
            String connectString = this.zkServer.getConnectString();
            Configuration conf = this.getSecretConf(connectString);
            DelegationTokenManager tm1 = new DelegationTokenManager(conf, new Text("bla"));
            tm1.init();
            tm2 = new DelegationTokenManager(conf, new Text("bla"));
            tm2.init();
            Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertNotNull((Object)token);
            tm2.verifyToken(token);
            tm2.renewToken(token, "foo");
            tm1.verifyToken(token);
            tm1.cancelToken(token, "foo");
            try {
                this.verifyTokenFail(tm2, (Token<DelegationTokenIdentifier>)token);
                Assert.fail((String)"Expected InvalidToken");
            }
            catch (SecretManager.InvalidToken it) {
                // empty catch block
            }
            token = tm2.createToken(UserGroupInformation.getCurrentUser(), "bar");
            Assert.assertNotNull((Object)token);
            tm1.verifyToken(token);
            tm1.renewToken(token, "bar");
            tm2.verifyToken(token);
            tm2.cancelToken(token, "bar");
            try {
                this.verifyTokenFail(tm1, (Token<DelegationTokenIdentifier>)token);
                Assert.fail((String)"Expected InvalidToken");
            }
            catch (SecretManager.InvalidToken it) {
                // empty catch block
            }
            this.verifyDestroy(tm1, conf);
            this.verifyDestroy(tm2, conf);
        }
    }

    @Test
    public void testNodeUpAferAWhile() throws Exception {
        for (int i = 0; i < 2; ++i) {
            String connectString = this.zkServer.getConnectString();
            Configuration conf = this.getSecretConf(connectString);
            DelegationTokenManager tm1 = new DelegationTokenManager(conf, new Text("bla"));
            tm1.init();
            Token token1 = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertNotNull((Object)token1);
            Token token2 = tm1.createToken(UserGroupInformation.getCurrentUser(), "bar");
            Assert.assertNotNull((Object)token2);
            Token token3 = tm1.createToken(UserGroupInformation.getCurrentUser(), "boo");
            Assert.assertNotNull((Object)token3);
            tm1.verifyToken(token1);
            tm1.verifyToken(token2);
            tm1.verifyToken(token3);
            tm1.cancelToken(token1, "foo");
            Thread.sleep(1000L);
            DelegationTokenManager tm2 = new DelegationTokenManager(conf, new Text("bla"));
            tm2.init();
            tm2.verifyToken(token2);
            tm2.verifyToken(token3);
            try {
                this.verifyTokenFail(tm2, (Token<DelegationTokenIdentifier>)token1);
                Assert.fail((String)"Expected InvalidToken");
            }
            catch (SecretManager.InvalidToken it) {
                // empty catch block
            }
            Token token4 = tm2.createToken(UserGroupInformation.getCurrentUser(), "xyz");
            Assert.assertNotNull((Object)token4);
            tm2.verifyToken(token4);
            tm1.verifyToken(token4);
            this.verifyDestroy(tm2, conf);
            Thread.sleep(1000L);
            DelegationTokenManager tm3 = new DelegationTokenManager(conf, new Text("bla"));
            tm3.init();
            tm3.verifyToken(token2);
            tm3.verifyToken(token3);
            tm3.verifyToken(token4);
            try {
                this.verifyTokenFail(tm3, (Token<DelegationTokenIdentifier>)token1);
                Assert.fail((String)"Expected InvalidToken");
            }
            catch (SecretManager.InvalidToken it) {
                // empty catch block
            }
            this.verifyDestroy(tm3, conf);
            this.verifyDestroy(tm1, conf);
        }
    }

    @Test
    public void testRenewTokenSingleManager() throws Exception {
        for (int i = 0; i < 2; ++i) {
            DelegationTokenManager tm1 = null;
            String connectString = this.zkServer.getConnectString();
            Configuration conf = this.getSecretConf(connectString);
            tm1 = new DelegationTokenManager(conf, new Text("foo"));
            tm1.init();
            Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertNotNull((Object)token);
            tm1.renewToken(token, "foo");
            tm1.verifyToken(token);
            this.verifyDestroy(tm1, conf);
        }
    }

    @Test
    public void testCancelTokenSingleManager() throws Exception {
        for (int i = 0; i < 2; ++i) {
            DelegationTokenManager tm1 = null;
            String connectString = this.zkServer.getConnectString();
            Configuration conf = this.getSecretConf(connectString);
            tm1 = new DelegationTokenManager(conf, new Text("foo"));
            tm1.init();
            Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
            Assert.assertNotNull((Object)token);
            tm1.cancelToken(token, "foo");
            try {
                this.verifyTokenFail(tm1, (Token<DelegationTokenIdentifier>)token);
                Assert.fail((String)"Expected InvalidToken");
            }
            catch (SecretManager.InvalidToken it) {
                it.printStackTrace();
            }
            this.verifyDestroy(tm1, conf);
        }
    }

    protected void verifyDestroy(DelegationTokenManager tm, Configuration conf) throws Exception {
        AbstractDelegationTokenSecretManager sm = tm.getDelegationTokenSecretManager();
        ZKDelegationTokenSecretManager zksm = (ZKDelegationTokenSecretManager)sm;
        ExecutorService es = zksm.getListenerThreadPool();
        tm.destroy();
        Assert.assertTrue((boolean)es.isShutdown());
        long timeout = conf.getLong("zk-dt-secret-manager.zkShutdownTimeout", 10000L);
        Thread.sleep(timeout * 3L);
        Assert.assertTrue((boolean)es.isTerminated());
    }

    @Test
    public void testStopThreads() throws Exception {
        DelegationTokenManager tm1 = null;
        String connectString = this.zkServer.getConnectString();
        long updateIntervalSeconds = 1L;
        long shutdownTimeoutMillis = 5000L;
        Configuration conf = this.getSecretConf(connectString);
        conf.setLong("delegation-token.update-interval.sec", 1L);
        conf.setLong("delegation-token.removal-scan-interval.sec", 1L);
        conf.setLong("delegation-token.renew-interval.sec", 1L);
        conf.setLong("zk-dt-secret-manager.zkShutdownTimeout", 5000L);
        tm1 = new DelegationTokenManager(conf, new Text("foo"));
        tm1.init();
        Token token = tm1.createToken(UserGroupInformation.getCurrentUser(), "foo");
        Assert.assertNotNull((Object)token);
        AbstractDelegationTokenSecretManager sm = tm1.getDelegationTokenSecretManager();
        ZKDelegationTokenSecretManager zksm = (ZKDelegationTokenSecretManager)sm;
        ExecutorService es = zksm.getListenerThreadPool();
        es.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Thread.sleep(10000L);
                return null;
            }
        });
        tm1.destroy();
    }

    @Test
    public void testACLs() throws Exception {
        String connectString = this.zkServer.getConnectString();
        Configuration conf = this.getSecretConf(connectString);
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        String userPass = "myuser:mypass";
        final ACL digestACL = new ACL(31, new Id("digest", DigestAuthenticationProvider.generateDigest((String)userPass)));
        ACLProvider digestAclProvider = new ACLProvider(){

            public List<ACL> getAclForPath(String path) {
                return this.getDefaultAcl();
            }

            public List<ACL> getDefaultAcl() {
                ArrayList<ACL> ret = new ArrayList<ACL>();
                ret.add(digestACL);
                return ret;
            }
        };
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)retryPolicy).aclProvider(digestAclProvider).authorization("digest", userPass.getBytes("UTF-8")).build();
        curatorFramework.start();
        ZKDelegationTokenSecretManager.setCurator((CuratorFramework)curatorFramework);
        DelegationTokenManager tm1 = new DelegationTokenManager(conf, new Text("bla"));
        tm1.init();
        String workingPath = conf.get("zk-dt-secret-manager.znodeWorkingPath");
        this.verifyACL(curatorFramework, "/" + workingPath, digestACL);
        tm1.destroy();
        ZKDelegationTokenSecretManager.setCurator(null);
        curatorFramework.close();
    }

    private void verifyACL(CuratorFramework curatorFramework, String path, ACL expectedACL) throws Exception {
        List acls = (List)curatorFramework.getACL().forPath(path);
        Assert.assertEquals((long)1L, (long)acls.size());
        Assert.assertEquals((Object)expectedACL, acls.get(0));
    }

    private void verifyTokenFail(DelegationTokenManager tm, Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        this.verifyTokenFailWithRetry(tm, token, 5);
    }

    private void verifyTokenFailWithRetry(DelegationTokenManager tm, Token<DelegationTokenIdentifier> token, int retryCount) throws IOException, InterruptedException {
        tm.verifyToken(token);
        if (retryCount > 0) {
            Thread.sleep(1000L);
            this.verifyTokenFailWithRetry(tm, token, retryCount - 1);
        }
    }
}

