/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.junit.Test;

public class TestUrlStreamHandlerFactory {
    private static final int RUNS = 20;
    private static final int THREADS = 10;
    private static final int TASKS = 200;
    private static final int TIMEOUT = 30;

    @Test
    public void testConcurrency() throws Exception {
        for (int i = 0; i < 20; ++i) {
            this.singleRun();
        }
    }

    private void singleRun() throws Exception {
        Future future;
        final FsUrlStreamHandlerFactory factory = new FsUrlStreamHandlerFactory();
        final Random random = new Random();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        ArrayList futures = new ArrayList(200);
        int i = 0;
        while (i < 200) {
            final int aux = i++;
            futures.add(executor.submit(new Runnable(){

                @Override
                public void run() {
                    int rand = aux + random.nextInt(3);
                    factory.createURLStreamHandler(String.valueOf(rand));
                }
            }));
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
            executor.shutdownNow();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Iterator iterator = futures.iterator();
        while (iterator.hasNext() && (future = (Future)iterator.next()).isDone()) {
            future.get();
        }
    }
}

